# Complete Optimization Problem and Solution: movie_1

## 1. Problem Context and Goals

### Context  
A movie streaming service is focused on optimizing how it allocates its promotional budget across various movies. The primary decision involves determining the amount of budget to allocate to each movie, represented by the decision variable budget_allocation[mID], which is continuous for each movie identified by mID. The service aims to enhance the average ratings of its movies by leveraging promotional spending. Each movie has a unique sensitivity to promotional efforts, which influences how effectively the budget impacts its ratings. The operational goal is to maximize the overall expected improvement in movie ratings by strategically distributing the promotional budget.

The business configuration includes a total promotional budget that serves as the upper limit for allocation. Additionally, there is a minimum promotional budget requirement for each movie to ensure that every movie receives a baseline level of promotion. These constraints are critical to maintaining a balanced promotional strategy that aligns with the service's operational and financial objectives.

### Goals  
The optimization goal is to maximize the expected increase in movie ratings by effectively allocating the promotional budget. The metric to optimize is the sum of the product of each movie's sensitivity to promotional spending and the allocated budget for that movie. Success is measured by the extent to which the promotional budget allocation enhances the overall ratings, with the sensitivity values serving as the coefficients that guide the optimization process. The objective is clearly defined in linear terms, focusing on maximizing the impact of promotional spending within the given constraints.

## 2. Constraints    

The optimization problem is subject to the following constraints:

- The total amount of budget allocated across all movies must not exceed the total promotional budget available. This ensures that the promotional spending remains within the financial limits set by the service.
- Each movie must receive at least a minimum promotional budget. This constraint guarantees that every movie benefits from a baseline level of promotion, which is essential for maintaining a consistent promotional strategy.

These constraints are expressed in linear terms, aligning with the business requirements and ensuring that the optimization problem remains within the realm of linear programming.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE promotion_sensitivity (
  mID INTEGER,
  sensitivity_value FLOAT
);

CREATE TABLE budget_allocation (
  mID INTEGER,
  amount FLOAT
);


```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization process, highlighting their business purposes and roles in the optimization model:

- **Promotion Sensitivity Table**: This table captures the sensitivity of each movie's rating to promotional spending. It includes:
  - **mID**: A unique identifier for each movie, serving as an index for sensitivity values.
  - **Sensitivity Value**: Represents how responsive a movie's rating is to promotional efforts, acting as a coefficient in the optimization objective.

- **Budget Allocation Table**: This table details the allocation of the promotional budget to each movie. It includes:
  - **mID**: A unique identifier for each movie, serving as an index for budget allocation.
  - **Amount**: The amount of budget allocated to each movie, functioning as a decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical promotional budget allocations and expected sensitivity of movie ratings to promotional efforts, ensuring a balanced distribution across movies.

-- Realistic data for promotion_sensitivity
INSERT INTO promotion_sensitivity (mID, sensitivity_value) VALUES (1, 0.15);
INSERT INTO promotion_sensitivity (mID, sensitivity_value) VALUES (2, 0.25);
INSERT INTO promotion_sensitivity (mID, sensitivity_value) VALUES (3, 0.1);

-- Realistic data for budget_allocation
INSERT INTO budget_allocation (mID, amount) VALUES (1, 20000);
INSERT INTO budget_allocation (mID, amount) VALUES (2, 30000);
INSERT INTO budget_allocation (mID, amount) VALUES (3, 15000);


```