# Complete Optimization Problem and Solution: music_1

## 1. Problem Context and Goals

### Context  
The music streaming service is focused on optimizing its storage allocation to enhance the overall user experience by maximizing the total rating of songs available on the platform. Each song is evaluated based on its rating, file size, and resolution quality. The decision to store a song is represented by a binary choice, where storing a song is indicated by a value of 1, and not storing it is indicated by a value of 0. The platform operates under specific constraints: a limited total storage capacity and a requirement for a minimum total resolution quality across all stored songs. These constraints ensure that the platform maintains a balance between quantity and quality, adhering to industry standards and operational limitations. The business configuration includes parameters such as the total storage capacity available for storing songs and the minimum total resolution quality required for stored songs, which are critical in guiding the optimization process.

### Goals  
The primary goal of the optimization is to maximize the total rating of the songs stored on the platform. This involves selecting a combination of songs that collectively offer the highest possible rating while respecting the constraints of storage capacity and resolution quality. The success of this optimization is measured by the total rating achieved, which is directly influenced by the ratings of the individual songs selected for storage. The objective is to ensure that the platform offers a high-quality music catalog that meets user expectations and operational requirements.

## 2. Constraints    

The optimization process is governed by two main constraints. First, the total file size of the stored songs must not exceed the available storage capacity. This ensures that the platform operates within its physical storage limits. Second, the combined resolution quality of the stored songs must meet or exceed a specified minimum threshold. This constraint guarantees that the platform maintains a certain level of audio quality, which is essential for user satisfaction. These constraints are linear in nature, focusing on the sum of individual song attributes to guide the decision-making process.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for missing data requirements and updating configuration logic for scalar parameters and formulas.

CREATE TABLE song (
  f_id INTEGER,
  rating FLOAT,
  file_size INTEGER
);

CREATE TABLE song_file_data (
  song_id INTEGER,
  resolution INTEGER
);
```

### Data Dictionary  
The data structure is designed to support the optimization process by providing essential information about each song. The "song" table contains metadata for each song, including a unique identifier, the song's rating, and its file size. This information is crucial for determining the song's contribution to the overall rating and its impact on storage capacity. The "song_file_data" table links each song to its resolution quality, which is used to ensure that the platform meets the minimum resolution quality constraint. Each table and column is aligned with the optimization roles, ensuring that the data supports the linear formulation of the problem.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical file sizes and resolutions for music streaming services, ensuring a mix of high and low ratings to reflect a realistic catalog.

-- Realistic data for song
INSERT INTO song (f_id, rating, file_size) VALUES (1, 4.5, 5000);
INSERT INTO song (f_id, rating, file_size) VALUES (2, 3.8, 3000);
INSERT INTO song (f_id, rating, file_size) VALUES (3, 5.0, 7000);

-- Realistic data for song_file_data
INSERT INTO song_file_data (song_id, resolution) VALUES (1, 1080);
INSERT INTO song_file_data (song_id, resolution) VALUES (2, 720);
INSERT INTO song_file_data (song_id, resolution) VALUES (3, 480);
```