# Complete Optimization Problem and Solution: network_1

## 1. Problem Context and Goals

### Context  
In a high school setting, the administration aims to enhance student social engagement by optimizing the number of mutual friendships. Each student can list a limited number of peers as friends, and the objective is to maximize the number of mutual friendships within these constraints. The decision-making process involves determining whether a student considers another student a friend, represented by a binary decision variable. The operational parameters include the maximum number of friends a student can have, which serves as a constraint in the optimization model. This approach ensures that the optimization problem remains linear, focusing on maximizing mutual friendships without involving complex relationships like products or divisions. The business configuration specifies that each student can have up to five friends, balancing social interaction with manageability.

### Goals  
The primary goal of this optimization problem is to maximize the number of mutual friendships among students. This involves maximizing the total count of pairs where both students consider each other friends. The success of this optimization is measured by the increase in mutual friendships, aligning with the expected sources of coefficients in the model. The objective is clearly defined in linear terms, focusing on enhancing social connections within the constraints of the maximum number of friends allowed per student.

## 2. Constraints    

The optimization model is subject to specific constraints that ensure it remains linear and aligned with business requirements:

- Each student can have a maximum of five friends. This constraint ensures that the number of friendships a student can list does not exceed the specified limit, maintaining manageability and fairness.
- Mutual friendships are required, meaning if student A considers student B a friend, then student B must also consider student A a friend. This constraint ensures that friendships are reciprocal, reflecting the true nature of mutual social connections.

These constraints are described in business terms that naturally lead to linear mathematical forms, avoiding any complex relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a table for constraint bounds and updating configuration logic for scalar parameters. The 'max_friends' constraint is moved to configuration logic due to insufficient data for a table.

CREATE TABLE Friend (
  student_id INTEGER,
  friend_id INTEGER
);
```

### Data Dictionary  
The data dictionary provides a business-oriented mapping of tables and columns to their purposes and roles in the optimization process:

- **Friend Table**: Represents the friendships between students.
  - **student_id**: This column identifies the student in the friendship pair. It plays a crucial role in determining the decision variables for the optimization model.
  - **friend_id**: This column identifies the friend in the friendship pair. It complements the student_id to form the decision variables necessary for the optimization.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were generated to reflect a realistic high school social network where each student can have up to 5 friends, ensuring a diverse set of mutual friendships.

-- Realistic data for Friend
INSERT INTO Friend (student_id, friend_id) VALUES (1, 2);
INSERT INTO Friend (student_id, friend_id) VALUES (2, 1);
INSERT INTO Friend (student_id, friend_id) VALUES (1, 3);
INSERT INTO Friend (student_id, friend_id) VALUES (3, 1);
INSERT INTO Friend (student_id, friend_id) VALUES (2, 3);
INSERT INTO Friend (student_id, friend_id) VALUES (3, 2);
```