# Complete Optimization Problem and Solution: network_2

## 1. Problem Context and Goals

### Context  
A social network company is focused on enhancing its marketing campaign's effectiveness by strategically selecting individuals within the network to target. The primary decision involves determining which individuals should be targeted to maximize the spread of influence throughout the network. Each individual has an associated influence potential, and the goal is to maximize the total influence by targeting the right people. The company operates under a budget constraint, which limits the total cost of targeting individuals. The decision to target an individual is represented by a binary variable, where each person can either be targeted or not. The influence potential of each person is quantified and used to guide the targeting decisions. The total budget available for this campaign is a critical parameter, ensuring that the targeting strategy remains financially viable.

### Goals  
The optimization goal is to maximize the total influence spread across the network. This involves selecting individuals whose influence potential, when targeted, contributes the most to the overall influence. The success of the campaign is measured by the total influence achieved, which is directly linked to the influence potential of the targeted individuals. The objective is to make these decisions in a way that maximizes the total influence while adhering to the budget constraint.

## 2. Constraints    

The campaign is subject to several constraints to ensure feasibility and alignment with business objectives. The primary constraint is the budget limitation, which dictates that the total cost of targeting individuals must not exceed the available budget. Each individual has a specific cost associated with targeting them, and the sum of these costs for all targeted individuals must remain within the budget. Additionally, the decision to target an individual is binary, meaning each person can either be targeted or not, with no partial targeting allowed. These constraints ensure that the optimization problem remains linear and manageable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for influence coefficients and costs, modifying existing tables for better mapping, and updating configuration logic for budget management.

CREATE TABLE InfluenceCoefficients (
  person_id INTEGER,
  influence_value FLOAT
);

CREATE TABLE TargetingCosts (
  person_id INTEGER,
  cost_value FLOAT
);

CREATE TABLE Person (
  name STRING,
  target BOOLEAN
);
```

### Data Dictionary  
The data used in this optimization problem is organized into three main tables, each serving a distinct purpose in the decision-making process:

- **InfluenceCoefficients**: This table captures the influence potential of each individual in the network. Each entry links a person to their influence value, which is a measure of their ability to spread influence if targeted. This data is crucial for determining the potential impact of targeting each individual.

- **TargetingCosts**: This table details the cost associated with targeting each person. Each entry connects a person to their targeting cost, which is used to ensure that the total cost of the campaign does not exceed the budget. This information is essential for maintaining financial feasibility.

- **Person**: This table stores information about individuals in the network, including their names and whether they are targeted in the campaign. The target column is a binary indicator used as a decision variable in the optimization model, representing the decision to target or not target each person.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical social network influence metrics and marketing budget constraints, ensuring a balance between influence potential and targeting costs.

-- Realistic data for InfluenceCoefficients
INSERT INTO InfluenceCoefficients (person_id, influence_value) VALUES (1, 1.5);
INSERT INTO InfluenceCoefficients (person_id, influence_value) VALUES (2, 0.9);
INSERT INTO InfluenceCoefficients (person_id, influence_value) VALUES (3, 1.2);

-- Realistic data for TargetingCosts
INSERT INTO TargetingCosts (person_id, cost_value) VALUES (1, 300.0);
INSERT INTO TargetingCosts (person_id, cost_value) VALUES (2, 150.0);
INSERT INTO TargetingCosts (person_id, cost_value) VALUES (3, 250.0);

-- Realistic data for Person
INSERT INTO Person (name, target) VALUES ('Alice', False);
INSERT INTO Person (name, target) VALUES ('Bob', True);
INSERT INTO Person (name, target) VALUES ('Charlie', False);
```