# Complete Optimization Problem and Solution: news_report

## 1. Problem Context and Goals

### Context  
The news agency is focused on optimizing the allocation of its journalists to various events. The primary decision involves determining whether a journalist should cover a specific event, represented by binary decisions for each journalist-event pair. The agency aims to maximize the total attendance at events covered by journalists, which is a linear objective. The operational parameters include the maximum number of events a journalist can cover and the total number of journalists available. These parameters are crucial for setting the constraints in the optimization model. The business configuration specifies that each journalist can cover up to a certain number of events, ensuring they are not overburdened, and reflects the total number of journalists available for assignments. This setup ensures that the problem remains linear, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The primary goal of the optimization is to maximize the total attendance at events covered by journalists. This involves maximizing the sum of the expected attendance at each event that a journalist covers. The success of this optimization is measured by the total attendance achieved, aligning with the expected coefficients derived from event attendance data. The objective is clearly defined in linear terms, focusing on maximizing the sum of attendance figures for events covered by journalists.

## 2. Constraints    

The constraints for this optimization problem are straightforward and linear. Each journalist can cover a limited number of events, ensuring they are not overworked. This is represented by a constraint that limits the sum of events assigned to each journalist to the maximum number of events they can cover. Additionally, the total number of journalists available imposes a constraint on the number of journalists that can be assigned to each event. These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring the problem remains within the realm of linear optimization.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing constraint bounds and modifying existing tables to better map decision variables. Configuration logic updates include moving scalar parameters to JSON for better management.

CREATE TABLE event (
  Event_ID INTEGER,
  Event_Attendance INTEGER
);

CREATE TABLE journalist_event_assignment (
  journalist_ID INTEGER,
  Event_ID INTEGER
);
```

### Data Dictionary  
The data dictionary provides a business-oriented view of the tables and columns, mapping them to their purposes and roles in the optimization process. 

- **Event Table**: This table stores information about each event, including the expected number of attendees. The Event_ID serves as a unique identifier for each event, while the Event_Attendance column provides the attendance figures used as coefficients in the optimization objective.

- **Journalist Event Assignment Table**: This table tracks which journalists are assigned to which events. The journalist_ID and Event_ID columns serve as indices for the decision variables, indicating the assignment of journalists to events.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were chosen to reflect a realistic scenario where journalists cover events with varying attendance, ensuring constraints are met and the optimization problem is solvable.

-- Realistic data for event
INSERT INTO event (Event_ID, Event_Attendance) VALUES (1, 150);
INSERT INTO event (Event_ID, Event_Attendance) VALUES (2, 250);
INSERT INTO event (Event_ID, Event_Attendance) VALUES (3, 100);

-- Realistic data for journalist_event_assignment
INSERT INTO journalist_event_assignment (journalist_ID, Event_ID) VALUES (1, 1);
INSERT INTO journalist_event_assignment (journalist_ID, Event_ID) VALUES (1, 2);
INSERT INTO journalist_event_assignment (journalist_ID, Event_ID) VALUES (2, 2);
INSERT INTO journalist_event_assignment (journalist_ID, Event_ID) VALUES (2, 3);
INSERT INTO journalist_event_assignment (journalist_ID, Event_ID) VALUES (3, 1);
```