# Complete Optimization Problem and Solution: orchestra

## 1. Problem Context and Goals

### Context  
The orchestra company is focused on maximizing the total attendance at their shows. This involves making strategic decisions about the number of performances for each show, which are represented by the decision variables: Performances[show_id] for each show_id. The primary objective is to maximize the total attendance, calculated as the sum of the expected attendance for each show multiplied by the number of performances for that show. This linear relationship ensures that the optimization problem remains straightforward and solvable.

The company must operate within certain constraints, including the total availability of conductors, which serves as a limit on the total number of performances across all shows. Additionally, each orchestra has a maximum number of performances it can handle, and each venue has a capacity limit that cannot be exceeded by the product of attendance and performances. These constraints are critical to maintaining operational feasibility and ensuring that the optimization remains linear.

The business configuration includes scalar parameters such as the total availability of conductors, which is a key constraint bound. This parameter reflects the realistic availability of conductors, considering their schedules and other commitments. The configuration logic is designed to separate business logic from value determination, allowing for flexible parameter tuning while maintaining consistency.

### Goals  
The primary goal of the optimization is to maximize the total attendance across all shows. This involves selecting the optimal number of performances for each show to achieve the highest possible attendance. The success of this optimization is measured by the total attendance, which is calculated as the sum of the expected attendance for each show multiplied by the number of performances. This linear optimization goal is clearly defined and aligns with the expected coefficient sources, ensuring that the problem remains solvable and practical.

## 2. Constraints    

The optimization problem is subject to several linear constraints that ensure feasibility and operational efficiency:

- The total number of performances across all shows must not exceed the total availability of conductors. This constraint ensures that the scheduling of performances is realistic and manageable given the conductor resources.
- Each orchestra has a maximum number of performances it can handle, which must not be exceeded. This constraint ensures that the workload for each orchestra remains within acceptable limits.
- The product of the expected attendance and the number of performances for each show must not exceed the venue's capacity. This constraint ensures that the audience size does not surpass what the venue can accommodate, maintaining safety and comfort.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data, modifying existing tables to fill mapping gaps, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE OrchestraPerformanceLimits (
  Orchestra_ID INTEGER,
  MaxPerformances INTEGER
);

CREATE TABLE VenueCapacity (
  Show_ID INTEGER,
  Capacity INTEGER
);

CREATE TABLE Show (
  Show_ID INTEGER,
  Attendance INTEGER,
  Performances INTEGER
);


```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **OrchestraPerformanceLimits**: This table defines the maximum number of performances each orchestra can handle. It plays a crucial role in setting constraint bounds for the optimization problem.
  - **Orchestra_ID**: A unique identifier for each orchestra, used as an index for constraint bounds.
  - **MaxPerformances**: The maximum number of performances allowed for each orchestra, serving as a constraint bound.

- **VenueCapacity**: This table specifies the capacity of each venue for shows, which is essential for setting constraint bounds related to attendance.
  - **Show_ID**: A unique identifier for each show, used as an index for constraint bounds.
  - **Capacity**: The maximum capacity of the venue, serving as a constraint bound for attendance.

- **Show**: This table stores information about each show, including expected attendance and the number of performances, which are key components of the optimization problem.
  - **Show_ID**: A unique identifier for each show, used as an index for decision variables.
  - **Attendance**: The expected attendance for each show, which acts as an objective coefficient in the optimization.
  - **Performances**: The number of performances for each show, serving as the decision variable in the optimization.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical orchestra performance schedules, venue capacities, and conductor availability to ensure a realistic and solvable optimization problem.

-- Realistic data for OrchestraPerformanceLimits
INSERT INTO OrchestraPerformanceLimits (Orchestra_ID, MaxPerformances) VALUES (1, 5);
INSERT INTO OrchestraPerformanceLimits (Orchestra_ID, MaxPerformances) VALUES (2, 10);
INSERT INTO OrchestraPerformanceLimits (Orchestra_ID, MaxPerformances) VALUES (3, 15);

-- Realistic data for VenueCapacity
INSERT INTO VenueCapacity (Show_ID, Capacity) VALUES (101, 200);
INSERT INTO VenueCapacity (Show_ID, Capacity) VALUES (102, 300);
INSERT INTO VenueCapacity (Show_ID, Capacity) VALUES (103, 400);

-- Realistic data for Show
INSERT INTO Show (Show_ID, Attendance, Performances) VALUES (101, 150, 1);
INSERT INTO Show (Show_ID, Attendance, Performances) VALUES (102, 250, 2);
INSERT INTO Show (Show_ID, Attendance, Performances) VALUES (103, 350, 3);


```