# Complete Optimization Problem and Solution: party_host

## 1. Problem Context and Goals

### Context  
The company is focused on organizing themed parties and aims to efficiently allocate hosts to these events. The primary decision involves determining whether a specific host is assigned to a particular party. This decision is represented by a binary choice, where each host can either be assigned or not assigned to a party. The operational goal is to minimize the total number of hosts required across all parties. Each party must have at least one main host to ensure smooth operations, and no party should exceed a predefined maximum number of hosts. This maximum is set to ensure effective management and avoid overcrowding. The business configuration includes a scalar parameter that specifies the maximum number of hosts allowed per party, which is crucial for maintaining the balance between adequate staffing and resource efficiency.

### Goals  
The optimization goal is to minimize the total number of hosts assigned to parties. The metric for optimization is the total count of host assignments, with the aim of reducing this number while still meeting the operational requirements of each party. Success is measured by achieving the minimum possible number of host assignments, ensuring that each party is adequately staffed without exceeding the maximum host limit. The focus is on a linear optimization approach, where the objective is to streamline host allocation in a straightforward and efficient manner.

## 2. Constraints    

The constraints for this optimization problem are straightforward and align with the linear mathematical formulation. Each party must have at least one host assigned to it, ensuring that all parties are adequately staffed. Additionally, the number of hosts assigned to any party should not exceed the maximum number of hosts allowed, as specified in the business configuration. These constraints ensure that the staffing levels are both sufficient and efficient, adhering to the operational limits set by the company.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and objective coefficients, modifying existing tables to fill mapping gaps, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE party_host_assignment (
  party_id INTEGER,
  host_id INTEGER,
  is_assigned BOOLEAN
);

CREATE TABLE objective_coefficients (
  coefficient_id INTEGER,
  coefficient_value FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization process, linking them to their business purposes and roles in the optimization model:

- **Party Host Assignment Table**: This table tracks which hosts are assigned to which parties. It includes:
  - **Party ID**: An identifier for each party, linking host assignments to specific events.
  - **Host ID**: An identifier for each host, ensuring that assignments are linked to the correct personnel.
  - **Is Assigned**: A binary indicator showing whether a host is assigned to a party, serving as the decision variable in the optimization model.

- **Objective Coefficients Table**: This table stores the coefficients used in the optimization objective function. It includes:
  - **Coefficient ID**: A unique identifier for each coefficient, ensuring clarity in the optimization process.
  - **Coefficient Value**: The value of the coefficient, used in calculating the objective function to minimize host assignments.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical party hosting scenarios, ensuring each party has a reasonable number of hosts and that the constraints are neither too tight nor too loose.

-- Realistic data for party_host_assignment
INSERT INTO party_host_assignment (party_id, host_id, is_assigned) VALUES (1, 101, True);
INSERT INTO party_host_assignment (party_id, host_id, is_assigned) VALUES (1, 102, True);
INSERT INTO party_host_assignment (party_id, host_id, is_assigned) VALUES (2, 103, True);
INSERT INTO party_host_assignment (party_id, host_id, is_assigned) VALUES (2, 104, True);
INSERT INTO party_host_assignment (party_id, host_id, is_assigned) VALUES (3, 105, True);

-- Realistic data for objective_coefficients
INSERT INTO objective_coefficients (coefficient_id, coefficient_value) VALUES (1, 1.0);
INSERT INTO objective_coefficients (coefficient_id, coefficient_value) VALUES (2, 1.0);
INSERT INTO objective_coefficients (coefficient_id, coefficient_value) VALUES (3, 1.0);
```