# Complete Optimization Problem and Solution: performance_attendance

## 1. Problem Context and Goals

### Context  
The theater company is focused on optimizing the allocation of its members to various performances. The primary decision involves determining the number of pieces each member will perform in each performance. This decision is represented by integer variables, where each variable corresponds to the number of pieces performed by a specific member in a specific performance. The operational goal is to maximize the total number of pieces performed across all performances. This objective aligns with the company's aim to enhance performance quality and audience satisfaction.

The business configuration includes key parameters such as the maximum number of attendees allowed per performance, which serves as a constraint bound in the optimization model. Additionally, there is a limit on the maximum number of pieces a member can perform, ensuring that member workload is manageable and sustainable. These parameters are critical in shaping the linear relationships that guide the optimization process.

The data presented reflects current operational realities, focusing on precise decision-making that naturally leads to linear formulations. Resource limitations, such as venue capacity and member availability, are considered to ensure that the optimization model remains realistic and applicable. The business configuration parameters are integral to the model, providing the necessary bounds and constraints to guide the optimization process effectively.

### Goals  
The primary goal of the optimization process is to maximize the total number of pieces performed by the theater company's members across all scheduled performances. This goal is achieved by strategically allocating members to performances in a way that maximizes the total output, measured by the sum of pieces performed. Success in this optimization effort is determined by the ability to reach or approach the maximum possible total of performed pieces, given the constraints of member availability and performance attendance limits. The optimization goal is articulated in straightforward business language, emphasizing the linear nature of the objective without resorting to mathematical notation.

## 2. Constraints    

The optimization model is subject to several constraints that ensure the solution is feasible and aligns with business realities:

- The total number of pieces performed in any given performance cannot exceed the maximum attendance capacity for that performance. This constraint ensures that the number of pieces aligns with the venue's capacity to accommodate attendees, maintaining a balance between performance quality and audience experience.

- Each member has a limit on the number of pieces they can perform, based on their availability. This constraint ensures that members are not overburdened and can perform at their best, contributing to the overall success of the performances.

These constraints are described in business terms that naturally lead to linear mathematical forms, avoiding complex relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Incorporated member availability data into the schema and moved scalar parameters to configuration logic. Adjusted schema to align with optimization requirements.

CREATE TABLE member_attendance (
  Member_ID INTEGER,
  Performance_ID INTEGER,
  Num_of_Pieces INTEGER
);

CREATE TABLE performance (
  Performance_ID INTEGER,
  Attendance INTEGER
);

CREATE TABLE member_availability (
  Member_ID INTEGER,
  Availability INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Member Attendance Table**: This table tracks the number of pieces each member performs in each performance. It plays a crucial role in the optimization process as it represents the decision variables. The columns include:
  - **Member_ID**: A unique identifier for each member, serving as an index for decision variables.
  - **Performance_ID**: A unique identifier for each performance, also serving as an index for decision variables.
  - **Num_of_Pieces**: The number of pieces performed by a member in a performance, representing the decision variable value.

- **Performance Table**: This table stores information about each performance, specifically the maximum number of pieces that can be performed. It serves as a constraint bound in the optimization model. The columns include:
  - **Performance_ID**: A unique identifier for each performance, serving as an index for constraints.
  - **Attendance**: The maximum number of pieces that can be performed in a performance, acting as a constraint bound.

- **Member Availability Table**: This table stores the availability of each member, which is used as a constraint bound in the optimization model. The columns include:
  - **Member_ID**: A unique identifier for each member, serving as an index for constraints.
  - **Availability**: The maximum number of pieces a member is available to perform, acting as a constraint bound.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical theater company operations, considering member availability, performance attendance limits, and realistic performance schedules.

-- Realistic data for member_attendance
INSERT INTO member_attendance (Member_ID, Performance_ID, Num_of_Pieces) VALUES (1, 101, 2);
INSERT INTO member_attendance (Member_ID, Performance_ID, Num_of_Pieces) VALUES (2, 102, 1);
INSERT INTO member_attendance (Member_ID, Performance_ID, Num_of_Pieces) VALUES (3, 103, 3);

-- Realistic data for performance
INSERT INTO performance (Performance_ID, Attendance) VALUES (101, 50);
INSERT INTO performance (Performance_ID, Attendance) VALUES (102, 60);
INSERT INTO performance (Performance_ID, Attendance) VALUES (103, 70);

-- Realistic data for member_availability
INSERT INTO member_availability (Member_ID, Availability) VALUES (1, 5);
INSERT INTO member_availability (Member_ID, Availability) VALUES (2, 10);
INSERT INTO member_availability (Member_ID, Availability) VALUES (3, 15);
```