# Complete Optimization Problem and Solution: phone_1

## 1. Problem Context and Goals

### Context  
A mobile phone company is focused on optimizing the production of its various phone models to achieve maximum profitability. The decision at hand involves determining the number of units to produce for each phone model, denoted as `units_produced[i]`, where `i` represents each distinct phone model. The primary objective is to maximize the total profit, which is calculated as the sum of the profit per unit for each model multiplied by the number of units produced for that model.

The company operates under specific resource constraints, which include the total available RAM, ROM, and screen resources. These constraints are critical as they define the maximum capacity for production. The total available RAM, ROM, and screen resources are scalar parameters that guide the production limits. The business configuration includes:

- Total available RAM for production, which serves as the constraint bound for RAM usage.
- Total available ROM for production, which serves as the constraint bound for ROM usage.
- Total available screen resources for production, which serves as the constraint bound for screen usage.

The operational parameters are aligned with a linear objective, ensuring that the decision-making process is straightforward and adheres to linear relationships. The focus is on precise operational decision-making that leads to linear formulations, avoiding any scenarios that would require nonlinear relationships such as variable products or divisions. The business configuration parameters are referenced appropriately to ensure a consistent and realistic production plan.

### Goals  
The primary goal of the optimization process is to maximize the total profit from the production of mobile phone models. This involves determining the optimal number of units to produce for each model to achieve the highest possible profit. The metric to optimize is the total profit, which is calculated as the sum of the profit per unit for each phone model multiplied by the number of units produced for that model. Success is measured by the alignment of production decisions with the expected profit coefficients, ensuring that the optimization goal is clearly defined and achievable within the given resource constraints.

## 2. Constraints    

The production process is subject to several constraints that ensure the efficient use of available resources. These constraints are described in business terms that naturally lead to linear mathematical forms:

- The total RAM required for the production of all phone models must not exceed the total available RAM. This constraint ensures that the production plan is feasible given the RAM resources.
- The total ROM required for the production of all phone models must not exceed the total available ROM. This constraint ensures that the production plan is feasible given the ROM resources.
- The total screen resources required for the production of all phone models must not exceed the total available screen resources. This constraint ensures that the production plan is feasible given the screen resources.

These constraints are critical in guiding the production decisions and ensuring that the optimization process remains within the bounds of available resources.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables, objective coefficients, and constraint bounds, and moving scalar parameters to configuration logic. This addresses the OR expert's mapping gaps and missing data requirements.

CREATE TABLE PhoneModels (
  model_id INTEGER,
  RAM_required INTEGER,
  ROM_required INTEGER,
  screen_required INTEGER
);

CREATE TABLE ObjectiveCoefficients (
  model_id INTEGER,
  profit_per_unit FLOAT
);

CREATE TABLE DecisionVariables (
  model_id INTEGER,
  units_produced INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **PhoneModels**: This table contains details of each phone model, including the resource requirements for RAM, ROM, and screen resources. It plays a crucial role in the optimization process by providing the necessary data for constraint calculations.
  - **model_id**: A unique identifier for each phone model, used to reference decision variables and coefficients.
  - **RAM_required**: The amount of RAM required per unit of the phone model, used in the RAM constraint calculation.
  - **ROM_required**: The amount of ROM required per unit of the phone model, used in the ROM constraint calculation.
  - **screen_required**: The screen resources required per unit of the phone model, used in the screen constraint calculation.

- **ObjectiveCoefficients**: This table contains the profit per unit for each phone model, serving as the objective coefficients in the optimization process.
  - **model_id**: A reference to the phone model, linking profit to the specific model.
  - **profit_per_unit**: The profit earned per unit of the phone model, used as a coefficient in the objective function.

- **DecisionVariables**: This table records the number of units produced for each phone model, representing the decision variables in the optimization model.
  - **model_id**: A reference to the phone model, linking production units to the specific model.
  - **units_produced**: The number of units produced for the phone model, serving as the decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical resource requirements and profit margins for different phone models, ensuring that the total available resources are sufficient to produce a meaningful number of units for each model.

-- Realistic data for PhoneModels
INSERT INTO PhoneModels (model_id, RAM_required, ROM_required, screen_required) VALUES (1, 4, 16, 1);
INSERT INTO PhoneModels (model_id, RAM_required, ROM_required, screen_required) VALUES (2, 8, 32, 2);
INSERT INTO PhoneModels (model_id, RAM_required, ROM_required, screen_required) VALUES (3, 16, 64, 3);

-- Realistic data for ObjectiveCoefficients
INSERT INTO ObjectiveCoefficients (model_id, profit_per_unit) VALUES (1, 50.0);
INSERT INTO ObjectiveCoefficients (model_id, profit_per_unit) VALUES (2, 75.0);
INSERT INTO ObjectiveCoefficients (model_id, profit_per_unit) VALUES (3, 100.0);

-- Realistic data for DecisionVariables
INSERT INTO DecisionVariables (model_id, units_produced) VALUES (1, 2000);
INSERT INTO DecisionVariables (model_id, units_produced) VALUES (2, 1000);
INSERT INTO DecisionVariables (model_id, units_produced) VALUES (3, 500);
```