# Complete Optimization Problem and Solution: product_catalog

## 1. Problem Context and Goals

### Context  
The company is focused on optimizing its product pricing strategy across multiple currencies to maximize revenue. The decision variables include setting prices in dollars, euros, and pounds for each product. The operational parameters are aligned with the objective of maximizing total revenue, which is calculated by summing the product of prices in each currency and their respective sales volumes. The business configuration includes exchange rates from dollars to euros and dollars to pounds, which are used to ensure price consistency across currencies. The data reflects current operational information, focusing on precise decision-making that leads to linear formulations. Resource limitations are considered through constraints such as stock availability and minimum price thresholds, avoiding scenarios that require nonlinear relationships. The business configuration parameters, including exchange rates, are integral to the pricing strategy.

### Goals  
The primary goal is to maximize the company's total revenue from product sales. This is achieved by adjusting the prices of products in dollars, euros, and pounds. The success of this optimization is measured by the total revenue, which is the sum of the product of prices in each currency and their respective sales volumes. The optimization goal is clearly defined in linear terms, focusing on maximizing revenue through strategic pricing decisions.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the solution is practical and aligned with business requirements:

- Each product's price in dollars must not be lower than its minimum allowable price in dollars.
- Each product's price in euros must not be lower than its minimum allowable price in euros.
- Each product's price in pounds must not be lower than its minimum allowable price in pounds.
- The sales volume for each product cannot exceed the available stock for that product.
- The price in euros for each product must be consistent with its price in dollars, adjusted by the exchange rate from dollars to euros.
- The price in pounds for each product must be consistent with its price in dollars, adjusted by the exchange rate from dollars to pounds.

These constraints are described in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains solvable within the defined parameters.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing data requirements and updating existing tables to fill mapping gaps. Configuration logic is updated to include scalar parameters and formulas.

CREATE TABLE Catalog_Contents (
  price_in_dollars FLOAT,
  price_in_euros FLOAT,
  price_in_pounds FLOAT,
  minimum_price_dollars FLOAT,
  minimum_price_euros FLOAT,
  minimum_price_pounds FLOAT
);

CREATE TABLE Product_Sales (
  product_id INTEGER,
  sales_volume INTEGER
);

CREATE TABLE Stock_Availability (
  product_id INTEGER,
  stock_available INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Catalog_Contents**: This table stores product pricing information across different currencies. It plays a crucial role in the optimization as it contains the decision variables for pricing strategy. The columns include:
  - **price_in_dollars**: Represents the price of the product in dollars, serving as a decision variable.
  - **price_in_euros**: Represents the price of the product in euros, serving as a decision variable.
  - **price_in_pounds**: Represents the price of the product in pounds, serving as a decision variable.
  - **minimum_price_dollars**: The minimum allowable price in dollars, serving as a constraint bound.
  - **minimum_price_euros**: The minimum allowable price in euros, serving as a constraint bound.
  - **minimum_price_pounds**: The minimum allowable price in pounds, serving as a constraint bound.

- **Product_Sales**: This table stores the expected sales volume for each product, which is a key component in the revenue maximization objective. The columns include:
  - **product_id**: A unique identifier for each product, linking sales volume to specific products.
  - **sales_volume**: Represents the expected sales volume for the product, serving as a coefficient in the revenue maximization objective.

- **Stock_Availability**: This table stores the available stock for each product, which is used as a constraint bound for sales volume. The columns include:
  - **product_id**: A unique identifier for each product, linking stock availability to specific products.
  - **stock_available**: Represents the available stock for the product, serving as a constraint bound.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical market conditions, exchange rates, and stock levels to ensure a realistic and solvable optimization problem.

-- Realistic data for Catalog_Contents
INSERT INTO Catalog_Contents (price_in_dollars, price_in_euros, price_in_pounds, minimum_price_dollars, minimum_price_euros, minimum_price_pounds) VALUES (12.99, 11.04, 9.74, 11.99, 10.19, 8.99);
INSERT INTO Catalog_Contents (price_in_dollars, price_in_euros, price_in_pounds, minimum_price_dollars, minimum_price_euros, minimum_price_pounds) VALUES (18.49, 15.72, 13.87, 16.99, 14.44, 12.74);
INSERT INTO Catalog_Contents (price_in_dollars, price_in_euros, price_in_pounds, minimum_price_dollars, minimum_price_euros, minimum_price_pounds) VALUES (25.0, 21.25, 18.75, 22.5, 19.13, 16.88);

-- Realistic data for Product_Sales
INSERT INTO Product_Sales (product_id, sales_volume) VALUES (1, 120);
INSERT INTO Product_Sales (product_id, sales_volume) VALUES (2, 180);
INSERT INTO Product_Sales (product_id, sales_volume) VALUES (3, 90);

-- Realistic data for Stock_Availability
INSERT INTO Stock_Availability (product_id, stock_available) VALUES (1, 150);
INSERT INTO Stock_Availability (product_id, stock_available) VALUES (2, 200);
INSERT INTO Stock_Availability (product_id, stock_available) VALUES (3, 100);
```