# Complete Optimization Problem and Solution: real_estate_properties

## 1. Problem Context and Goals

### Context  
The real estate company is focused on maximizing its profit by strategically selecting properties to sell. Each property decision is represented by a binary choice, indicating whether a property is selected for sale. The company aims to optimize its operations by considering the agreed selling price and the vendor requested price for each property. The business configuration includes several key parameters: the maximum number of properties that can be sold, the maximum total number of rooms across all selected properties, and the minimum number of properties that must have a desired feature. These parameters are crucial for maintaining operational efficiency and aligning with market demands. The company uses these parameters to guide its decision-making process, ensuring that the selection of properties is both profitable and manageable. The focus is on linear relationships, avoiding complex interactions such as variable products or divisions, to maintain clarity and simplicity in the optimization model.

### Goals  
The primary goal of the optimization is to maximize the total profit from selling selected properties. This is achieved by focusing on the difference between the agreed selling price and the vendor requested price for each property. The success of this optimization is measured by the total profit generated, which is directly linked to the selection of properties that meet the business's strategic criteria. The objective is clearly defined in linear terms, ensuring that the optimization process is straightforward and aligned with the company's financial goals.

## 2. Constraints    

The optimization process is guided by several constraints that ensure the selection of properties aligns with the company's operational capabilities and market strategy:

- The total number of properties selected for sale must not exceed the maximum limit set by the company. This constraint ensures that the company does not overextend its resources and maintains a focus on quality over quantity.
- The total number of rooms across all selected properties must remain within a specified limit. This constraint helps manage the operational complexity and ensures that the company can effectively handle the properties it chooses to sell.
- A minimum number of selected properties must possess a desired feature. This constraint ensures that the properties chosen align with market demands and enhance the company's competitive edge.

These constraints are expressed in linear terms, ensuring that the optimization model remains simple and effective.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for decision variables and constraint bounds, modifying existing tables to fill mapping gaps, and moving scalar parameters to configuration logic.

CREATE TABLE Properties (
  agreed_selling_price FLOAT,
  vendor_requested_price FLOAT,
  room_count INTEGER,
  apt_feature_1 STRING
);

CREATE TABLE DecisionVariables (
  property_id INTEGER,
  selected BOOLEAN
);

CREATE TABLE ConstraintBounds (
  constraint_name STRING,
  bound_value INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization process, highlighting their business purposes and roles in the optimization model:

- **Properties Table**: This table contains information about each real estate property, including the agreed selling price, vendor requested price, number of rooms, and specific features. These attributes are crucial for calculating potential profit and determining the suitability of each property for sale.
  - **Agreed Selling Price**: Represents the price agreed upon for selling the property, used to calculate potential profit.
  - **Vendor Requested Price**: The price initially requested by the vendor, used in profit calculations.
  - **Room Count**: Indicates the number of rooms in the property, used to ensure room count constraints are met.
  - **Apartment Feature**: Describes a specific feature of the property, used to ensure that properties with desired features are selected.

- **DecisionVariables Table**: This table stores the decision variables, indicating whether each property is selected for sale. It links each decision to a specific property, facilitating the optimization process.

- **ConstraintBounds Table**: This table defines the bounds for various constraints, such as the maximum number of properties that can be sold, the maximum total number of rooms, and the minimum number of properties with desired features. These bounds are essential for guiding the optimization process and ensuring that the company's strategic goals are met.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical real estate market conditions, ensuring a mix of property types and features to reflect realistic scenarios. Prices and features were chosen to create a diverse portfolio that aligns with the constraints and objectives of the optimization problem.

-- Realistic data for Properties
INSERT INTO Properties (agreed_selling_price, vendor_requested_price, room_count, apt_feature_1) VALUES (120000.0, 110000.0, 3, 'desired_feature');
INSERT INTO Properties (agreed_selling_price, vendor_requested_price, room_count, apt_feature_1) VALUES (180000.0, 170000.0, 4, 'other_feature');
INSERT INTO Properties (agreed_selling_price, vendor_requested_price, room_count, apt_feature_1) VALUES (250000.0, 240000.0, 5, 'desired_feature');
INSERT INTO Properties (agreed_selling_price, vendor_requested_price, room_count, apt_feature_1) VALUES (95000.0, 90000.0, 2, 'desired_feature');
INSERT INTO Properties (agreed_selling_price, vendor_requested_price, room_count, apt_feature_1) VALUES (130000.0, 125000.0, 3, 'other_feature');

-- Realistic data for DecisionVariables
INSERT INTO DecisionVariables (property_id, selected) VALUES (1, True);
INSERT INTO DecisionVariables (property_id, selected) VALUES (2, False);
INSERT INTO DecisionVariables (property_id, selected) VALUES (3, True);
INSERT INTO DecisionVariables (property_id, selected) VALUES (4, True);
INSERT INTO DecisionVariables (property_id, selected) VALUES (5, False);

-- Realistic data for ConstraintBounds
INSERT INTO ConstraintBounds (constraint_name, bound_value) VALUES ('max_properties_to_sell', 3);
INSERT INTO ConstraintBounds (constraint_name, bound_value) VALUES ('max_total_rooms', 12);
INSERT INTO ConstraintBounds (constraint_name, bound_value) VALUES ('min_desired_features', 2);
```