# Complete DOCPLEX implementation - Retry Attempt 2

from docplex.mp.model import Model

def optimize_bank_funds():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="small_bank_1")
    
    # Data from the problem statement
    savings_interest_rates = [0.012, 0.015, 0.018]
    checking_interest_rates = [0.006, 0.008, 0.01]
    total_funds = [5000.0, 10000.0, 15000.0]
    min_savings_balance = [1000.0, 2000.0, 3000.0]  # Assumed minimum balances
    min_checking_balance = [500.0, 1000.0, 1500.0]  # Assumed minimum balances
    
    # Validate array lengths to prevent IndexError
    assert len(savings_interest_rates) == len(checking_interest_rates) == len(total_funds) == len(min_savings_balance) == len(min_checking_balance), "Array length mismatch"
    safe_range = range(len(total_funds))  # Safe indexing
    
    # 2. VARIABLES
    s = {i: mdl.continuous_var(name=f"s_{i}", lb=min_savings_balance[i]) for i in safe_range}
    c = {i: mdl.continuous_var(name=f"c_{i}", lb=min_checking_balance[i]) for i in safe_range}
    
    # 3. OBJECTIVE FUNCTION
    objective = mdl.sum(savings_interest_rates[i] * s[i] + checking_interest_rates[i] * c[i] for i in safe_range)
    mdl.maximize(objective)
    
    # 4. CONSTRAINTS
    for i in safe_range:
        # Total Funds Constraint
        mdl.add_constraint(s[i] + c[i] <= total_funds[i], ctname=f"total_funds_{i}")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for i in safe_range:
            savings_value = solution.get_value(s[i])
            checking_value = solution.get_value(c[i])
            print(f"Customer {i}: Savings = {savings_value:.2f}, Checking = {checking_value:.2f}")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")

    return mdl

# Run the optimization
optimize_bank_funds()