# Complete Optimization Problem and Solution: small_bank_1

## 1. Problem Context and Goals

### Context  
A small bank is focused on optimizing how customer funds are allocated between savings and checking accounts. The primary decision involves determining the amount of money each customer should allocate to their savings and checking accounts. The goal is to maximize the interest earned from these allocations. Each customer's savings and checking balances are treated as continuous decision variables. The bank aims to maximize the total interest earned by applying the respective interest rates to these balances. 

The bank operates under specific business configurations, which include maintaining a minimum required balance for both savings and checking accounts. These minimum balances are crucial for ensuring that customers can earn interest and manage daily transactions effectively. The bank also ensures that the total allocation of funds does not exceed the available funds for each customer. 

The operational parameters are aligned with a linear objective, focusing on maximizing the total interest earned. The bank's business logic is designed to ensure that all decisions and constraints are linear, avoiding any complex relationships such as variable products or divisions. The interest rates applied to savings and checking accounts serve as the coefficients in the optimization model, and the minimum balance requirements are used as constraint bounds.

### Goals  
The primary goal of the bank is to maximize the total interest earned from customer accounts. This involves optimizing the allocation of funds between savings and checking accounts for each customer. The success of this optimization is measured by the total interest earned, which is calculated by applying the respective interest rates to the savings and checking balances. The bank's objective is to achieve the highest possible total interest while adhering to the constraints of minimum balance requirements and total available funds. The optimization goal is clearly defined in linear terms, focusing on maximizing the interest without involving any complex mathematical operations.

## 2. Constraints    

The bank operates under several key constraints to ensure that the optimization problem remains linear and feasible:

- **Total Funds Constraint**: For each customer, the combined allocation to savings and checking accounts must not exceed the total funds available. This ensures that the bank does not allocate more funds than are available for each customer.

- **Minimum Savings Balance Constraint**: Each customer's savings account must maintain a minimum balance. This requirement ensures that customers can earn interest on their savings and aligns with typical banking policies.

- **Minimum Checking Balance Constraint**: Each customer's checking account must also maintain a minimum balance. This constraint ensures that customers have sufficient funds for daily transactions, which is a common practice in banking.

These constraints are described in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains straightforward and solvable using linear programming techniques.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for interest rates and minimum balances, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE SAVINGS (
  balance FLOAT,
  interest_rate FLOAT
);

CREATE TABLE CHECKING (
  balance FLOAT,
  interest_rate FLOAT
);

CREATE TABLE CUSTOMER_FUNDS (
  total_funds FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization problem, highlighting their business purposes and roles in the optimization process:

- **SAVINGS Table**: This table stores information about the savings accounts for each customer. It includes the balance allocated to savings and the interest rate applied to these balances. The balance serves as a decision variable, while the interest rate acts as an objective coefficient.

- **CHECKING Table**: Similar to the savings table, this table contains data about the checking accounts for each customer. It includes the balance allocated to checking and the interest rate applied. The balance is a decision variable, and the interest rate is an objective coefficient.

- **CUSTOMER_FUNDS Table**: This table records the total funds available for allocation for each customer. The total funds serve as a constraint bound, ensuring that the allocation to savings and checking does not exceed the available funds.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical banking practices, ensuring that interest rates are competitive and balances are realistic for a small bank's customer base.

-- Realistic data for SAVINGS
INSERT INTO SAVINGS (balance, interest_rate) VALUES (1500.0, 0.012);
INSERT INTO SAVINGS (balance, interest_rate) VALUES (2500.0, 0.015);
INSERT INTO SAVINGS (balance, interest_rate) VALUES (3500.0, 0.018);

-- Realistic data for CHECKING
INSERT INTO CHECKING (balance, interest_rate) VALUES (800.0, 0.006);
INSERT INTO CHECKING (balance, interest_rate) VALUES (1200.0, 0.008);
INSERT INTO CHECKING (balance, interest_rate) VALUES (1800.0, 0.01);

-- Realistic data for CUSTOMER_FUNDS
INSERT INTO CUSTOMER_FUNDS (total_funds) VALUES (5000.0);
INSERT INTO CUSTOMER_FUNDS (total_funds) VALUES (10000.0);
INSERT INTO CUSTOMER_FUNDS (total_funds) VALUES (15000.0);
```