# Complete Optimization Problem and Solution: student_1

## 1. Problem Context and Goals

### Context  
In a school setting, the administration is tasked with efficiently assigning students to classrooms. The primary decision involves determining which students are assigned to which classrooms, represented by a binary decision variable indicating if a student is assigned to a particular classroom. The operational goal is to minimize the maximum number of students in any classroom, ensuring that each classroom is adequately staffed with at least one teacher. The business configuration includes a parameter that sets the maximum number of students allowed in any classroom, which is a common standard to balance teacher workload and classroom management. This parameter is crucial for setting the upper limit of students per classroom in the optimization model. The data reflects current operational information, focusing on precise decision-making that aligns with linear optimization formulations. Resource limitations are expressed through constraints that ensure no classroom exceeds its capacity and each student is assigned to exactly one classroom.

### Goals  
The optimization goal is to minimize the maximum number of students assigned to any classroom. This objective is measured by the number of students in the most populated classroom, with success defined by achieving the smallest possible maximum. The aim is to distribute students in a way that balances classroom sizes, ensuring no classroom is overcrowded, thereby optimizing the learning environment and teacher effectiveness.

## 2. Constraints    

The constraints for this optimization problem are straightforward and align with linear mathematical forms. Each classroom has a capacity limit, meaning the total number of students assigned to a classroom cannot exceed its maximum capacity. This is represented by ensuring the sum of assignments for all students to a particular classroom does not surpass the classroom's capacity. Additionally, each student must be assigned to exactly one classroom, ensuring that every student is accounted for in the assignment process. These constraints are essential for maintaining a balanced and feasible distribution of students across classrooms.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, modifying existing tables to fill mapping gaps, and moving scalar parameters to configuration logic.

CREATE TABLE DecisionVariables (
  student_id INTEGER,
  classroom_id INTEGER,
  assignment BOOLEAN
);

CREATE TABLE ClassroomCapacity (
  classroom_id INTEGER,
  max_students INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization problem, highlighting their business purposes and roles in the optimization process:

- **DecisionVariables Table**: This table captures the assignment of students to classrooms. It includes:
  - **student_id**: A unique identifier for each student, used to track individual assignments.
  - **classroom_id**: A unique identifier for each classroom, linking students to specific classrooms.
  - **assignment**: A binary indicator showing whether a student is assigned to a particular classroom.

- **ClassroomCapacity Table**: This table defines the capacity constraints for each classroom. It includes:
  - **classroom_id**: A unique identifier for each classroom, used to apply capacity constraints.
  - **max_students**: The maximum number of students allowed in each classroom, setting the upper bound for student assignments.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical classroom sizes and student distribution in a school setting, ensuring that the optimization problem remains solvable and realistic.

-- Realistic data for DecisionVariables
INSERT INTO DecisionVariables (student_id, classroom_id, assignment) VALUES (1, 101, True);
INSERT INTO DecisionVariables (student_id, classroom_id, assignment) VALUES (2, 102, True);
INSERT INTO DecisionVariables (student_id, classroom_id, assignment) VALUES (3, 103, True);
INSERT INTO DecisionVariables (student_id, classroom_id, assignment) VALUES (4, 101, True);
INSERT INTO DecisionVariables (student_id, classroom_id, assignment) VALUES (5, 102, True);

-- Realistic data for ClassroomCapacity
INSERT INTO ClassroomCapacity (classroom_id, max_students) VALUES (101, 25);
INSERT INTO ClassroomCapacity (classroom_id, max_students) VALUES (102, 30);
INSERT INTO ClassroomCapacity (classroom_id, max_students) VALUES (103, 35);
```