# Complete Optimization Problem and Solution: Swimming

## 1. Problem Context and Goals

### Context  
In the competitive swimming domain, the primary objective is to optimize the allocation of swimmers to various events to maximize the overall performance score. This involves making strategic decisions about which swimmers participate in which events. Each decision is represented by a binary choice, indicating whether a swimmer is assigned to a specific event. The operational goal is to maximize the total performance score, which is calculated by summing the performance scores of swimmers across all events they participate in. 

The business configuration includes a critical parameter: the maximum number of events a swimmer can participate in. This parameter ensures that swimmers are not over-committed, allowing them to maintain high performance levels. Additionally, each event is subject to stadium capacity constraints, ensuring that the number of participants does not exceed the venue's limits. These constraints are linear in nature, aligning with the overall linear optimization framework.

### Goals  
The primary goal of this optimization problem is to maximize the total performance score of swimmers across all events. This involves selecting the optimal set of swimmer-event assignments that yield the highest cumulative performance score. Success is measured by the total performance score achieved, which is directly influenced by the performance scores of individual swimmers in their respective events. The optimization process is linear, focusing on maximizing this score without involving complex mathematical operations.

## 2. Constraints    

The optimization problem is subject to two main constraints:

- Each swimmer can participate in a limited number of events, as defined by the maximum events per swimmer parameter. This ensures that no swimmer is over-committed, maintaining their ability to perform optimally.
  
- Each event has a stadium capacity limit, which restricts the number of swimmers that can participate in that event. This constraint ensures that the number of participants does not exceed the venue's capacity, maintaining safety and logistical feasibility.

These constraints are expressed in a linear form, ensuring that the optimization problem remains within the realm of linear programming.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added StadiumCapacities table to address missing stadium capacity data requirement and updated business configuration logic for scalar parameters.

CREATE TABLE PerformanceScores (
  swimmer_id INTEGER,
  event_id INTEGER,
  performance_score FLOAT
);

CREATE TABLE SwimmerEventAssignments (
  swimmer_id INTEGER,
  event_id INTEGER,
  assignment BOOLEAN
);

CREATE TABLE StadiumCapacities (
  event_id INTEGER,
  capacity INTEGER
);
```

### Data Dictionary  
The data used in this optimization problem is structured into three main tables, each serving a specific business purpose:

- **PerformanceScores**: This table records the performance scores of swimmers in various events. Each entry includes a swimmer identifier, an event identifier, and the corresponding performance score. These scores serve as the coefficients in the objective function, representing the potential contribution of each swimmer-event assignment to the total performance score.

- **SwimmerEventAssignments**: This table tracks the assignments of swimmers to events. Each entry indicates whether a swimmer is assigned to a particular event. The assignment is a binary decision variable, reflecting the choice of whether a swimmer participates in an event.

- **StadiumCapacities**: This table contains the capacity limits for each event's venue. Each entry specifies the maximum number of participants allowed in an event, serving as a constraint bound in the optimization model.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical swimming event sizes, swimmer capabilities, and stadium capacities to ensure a balanced and realistic optimization scenario.

-- Realistic data for PerformanceScores
INSERT INTO PerformanceScores (swimmer_id, event_id, performance_score) VALUES (1, 101, 9.5);
INSERT INTO PerformanceScores (swimmer_id, event_id, performance_score) VALUES (2, 102, 8.7);
INSERT INTO PerformanceScores (swimmer_id, event_id, performance_score) VALUES (3, 103, 9.0);

-- Realistic data for SwimmerEventAssignments
INSERT INTO SwimmerEventAssignments (swimmer_id, event_id, assignment) VALUES (1, 101, True);
INSERT INTO SwimmerEventAssignments (swimmer_id, event_id, assignment) VALUES (2, 102, True);
INSERT INTO SwimmerEventAssignments (swimmer_id, event_id, assignment) VALUES (3, 103, True);

-- Realistic data for StadiumCapacities
INSERT INTO StadiumCapacities (event_id, capacity) VALUES (101, 500);
INSERT INTO StadiumCapacities (event_id, capacity) VALUES (102, 1000);
INSERT INTO StadiumCapacities (event_id, capacity) VALUES (103, 1500);
```