# Complete Optimization Problem and Solution: tvshow

## 1. Problem Context and Goals

### Context  
The TV network is focused on optimizing its programming schedule to enhance viewership across its various channels. The primary decision involves selecting which TV series and cartoons to air, represented by a binary decision variable indicating whether a particular show is chosen for airing. The network aims to maximize total viewership by considering the number of viewers each show attracts. The operational parameters include the total available air time for each channel, the maximum allowable content type per channel, and the minimum required viewership from specific demographic groups. These parameters are crucial constraints in the optimization model, ensuring that the schedule adheres to channel capacities and demographic targets. The business configuration provides these parameters as scalar values, reflecting realistic operational limits and goals.

### Goals  
The optimization goal is to maximize the total viewership across all channels. This is achieved by selecting the optimal combination of TV series and cartoons to air, with the metric for optimization being the total number of viewers. Success is measured by the ability to maximize this viewership while adhering to the constraints provided by the operational parameters. The goal is articulated in natural language, focusing on increasing the audience size through strategic programming decisions.

## 2. Constraints    

The constraints for this optimization problem are designed to ensure that the programming schedule is feasible and meets the network's operational requirements:

- The total air time used by the selected TV series and cartoons must not exceed the available air time for each channel. This ensures that the schedule fits within the channel's broadcasting capacity.
- The content type selected for each channel must not exceed the channel's content capacity. This constraint ensures a balanced and diverse programming lineup.
- The selected programming must achieve a minimum viewership from specific demographic groups, ensuring that the network meets its audience engagement targets.

These constraints are expressed in business terms that naturally align with linear mathematical forms, avoiding any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data, modifying existing tables to fill mapping gaps, and moving certain parameters to configuration logic for better management.

CREATE TABLE TV_series (
  Viewers_m INTEGER,
  Air_Time INTEGER,
  Content_Type STRING,
  Demographic_Target INTEGER,
  selected BOOLEAN
);

CREATE TABLE Channel (
  Total_Available_Time INTEGER,
  Content_Capacity INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **TV_series Table**: This table stores information about TV series and cartoons, crucial for scheduling optimization.
  - **Viewers_m**: Represents the number of viewers in millions for each show, serving as the objective coefficient for maximizing viewership.
  - **Air_Time**: Indicates the air time required for each show, used as a constraint for total available time.
  - **Content_Type**: Describes the type of content (e.g., series, cartoon), used to ensure content capacity constraints are met.
  - **Demographic_Target**: Specifies the target demographic viewership, ensuring that minimum demographic targets are achieved.
  - **selected**: A binary indicator of whether a show is selected to air, serving as the decision variable in the optimization.

- **Channel Table**: This table contains data about each channel's scheduling constraints.
  - **Total_Available_Time**: The total air time available for each channel, used as a constraint in the optimization model.
  - **Content_Capacity**: The maximum allowable content type per channel, ensuring a balanced programming schedule.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical TV network scheduling constraints and viewership data, ensuring a balance between available air time, content capacity, and demographic targets.

-- Realistic data for TV_series
INSERT INTO TV_series (Viewers_m, Air_Time, Content_Type, Demographic_Target, selected) VALUES (2, 60, 'series', 80000, False);
INSERT INTO TV_series (Viewers_m, Air_Time, Content_Type, Demographic_Target, selected) VALUES (3, 90, 'cartoon', 120000, False);
INSERT INTO TV_series (Viewers_m, Air_Time, Content_Type, Demographic_Target, selected) VALUES (1, 30, 'series', 50000, False);

-- Realistic data for Channel
INSERT INTO Channel (Total_Available_Time, Content_Capacity) VALUES (48, 20);
INSERT INTO Channel (Total_Available_Time, Content_Capacity) VALUES (72, 30);
INSERT INTO Channel (Total_Available_Time, Content_Capacity) VALUES (24, 10);
```