# Complete Optimization Problem and Solution: twitter_1

## 1. Problem Context and Goals

### Context  
The business objective is to optimize the allocation of promotional tweets to users in a way that maximizes overall user engagement. Each user is considered for receiving a promotional tweet, and the decision is represented by a binary variable indicating whether a user receives the tweet. The goal is to maximize the sum of engagement scores, where each score is associated with a user and reflects the expected engagement if the user receives the tweet.

Operational parameters include:
- A maximum limit on the number of promotional tweets a user can receive, ensuring users are not overwhelmed with promotions.
- A minimum engagement score threshold that a user must meet to be eligible for receiving a promotional tweet, ensuring that only users with a reasonable likelihood of engagement are targeted.
- A total cap on the number of followers that can be targeted with promotional tweets, balancing reach with platform constraints.

These parameters are derived from business configuration settings, which are designed to maintain user satisfaction and platform efficiency. The problem is structured to ensure that all decisions and constraints align with linear optimization principles, avoiding any nonlinear relationships.

### Goals  
The primary goal of this optimization problem is to maximize the total engagement score across all users. This is achieved by selecting users to receive promotional tweets based on their engagement coefficients. The success of this optimization is measured by the total engagement score, which is the sum of the engagement coefficients for all users who receive the promotional tweet. The objective is clearly defined in linear terms, focusing on maximizing the sum of engagement scores.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the solution is feasible and aligns with business objectives:

- The total number of users receiving promotional tweets must not exceed the platform's follower limit. This ensures that the promotional reach is within the platform's capacity.
- Each user selected to receive a promotional tweet must have an engagement score that meets or exceeds the minimum engagement threshold. This ensures that only users with a high likelihood of engagement are targeted.
- The decision variable for each user is binary, indicating whether the user receives the promotional tweet or not. This constraint ensures that each user is either selected or not, with no partial selections.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring the problem remains within the scope of linear optimization.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data and updating configuration logic for scalar parameters and formulas.

CREATE TABLE user_profiles (
  uid INTEGER,
  engagement_coefficient FLOAT
);

CREATE TABLE engagement_coefficients (
  user_id INTEGER,
  coefficient FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **User Profiles Table**: This table stores information about each user, including their unique identifier and engagement coefficient. The engagement coefficient represents the expected engagement score if the user receives a promotional tweet. This table plays a dual role in the optimization process, serving as both the source of decision variables and objective coefficients.

  - **User ID (uid)**: A unique identifier for each user, used as the index for decision variables.
  - **Engagement Coefficient**: Represents the expected engagement score for a user if they receive the promotional tweet, serving as the objective coefficient in the optimization problem.

- **Engagement Coefficients Table**: This table stores engagement coefficients for each user, linking user identifiers to their respective engagement scores. It serves as a source of objective coefficients in the optimization process.

  - **User ID**: Links to the decision variable, ensuring that each engagement coefficient is associated with the correct user.
  - **Coefficient**: Represents the engagement coefficient for each user, used as the objective coefficient in the optimization problem.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical user engagement metrics and platform constraints to ensure a realistic and solvable optimization problem.

-- Realistic data for user_profiles
INSERT INTO user_profiles (uid, engagement_coefficient) VALUES (1, 0.6);
INSERT INTO user_profiles (uid, engagement_coefficient) VALUES (2, 0.8);
INSERT INTO user_profiles (uid, engagement_coefficient) VALUES (3, 0.4);

-- Realistic data for engagement_coefficients
INSERT INTO engagement_coefficients (user_id, coefficient) VALUES (1, 0.6);
INSERT INTO engagement_coefficients (user_id, coefficient) VALUES (2, 0.8);
INSERT INTO engagement_coefficients (user_id, coefficient) VALUES (3, 0.4);
```