# Complete Optimization Problem and Solution: voter_2

## 1. Problem Context and Goals

### Context  
The university is focused on optimizing the election of student representatives to various leadership positions. The aim is to maximize student satisfaction by ensuring that the most popular candidates, as determined by voting records, are elected. The decision-making process involves selecting students for the roles of President, Vice President, Secretary, Treasurer, Class President, and Class Senator. Each of these roles is represented by a binary decision variable, indicating whether a student is elected to that position. The operational goal is to maximize the total number of votes received by the elected representatives. This is achieved by summing the votes for each position, weighted by whether the student is elected. The business logic ensures that exactly one student is elected to each position and that no student holds more than one position. This approach aligns with linear optimization principles, focusing on clear, linear relationships without involving complex mathematical operations like products or divisions. The constraints are designed to ensure that each position is filled by exactly one student and that each student can hold only one position, reflecting the university's commitment to fair and efficient representation.

### Goals  
The primary goal of this optimization problem is to maximize the total number of votes received by the elected student representatives. This involves selecting candidates who have received the highest number of votes for each position, thereby ensuring that the elected representatives reflect the preferences of the student body. The success of this optimization is measured by the total votes accumulated across all positions, with the objective being to maximize this total. The linear nature of this goal is emphasized by the straightforward summation of votes, weighted by the binary decision variables indicating election outcomes.

## 2. Constraints    

The constraints for this optimization problem are designed to ensure a fair and efficient election process. Each position must be filled by exactly one student, which means that the sum of the binary decision variables for each position must equal one. Additionally, each student can hold only one position, ensuring that the sum of the decision variables for all positions for a single student does not exceed one. These constraints are expressed in a linear form, aligning with the principles of linear optimization and ensuring that the election process is both fair and efficient.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for decision variables and constraint bounds, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE Voting_record (
  President_Vote INTEGER,
  Vice_President_Vote INTEGER,
  Secretary_Vote INTEGER,
  Treasurer_Vote INTEGER,
  Class_President_Vote INTEGER,
  Class_Senator_Vote INTEGER
);

CREATE TABLE Decision_Variables (
  President BOOLEAN,
  Vice_President BOOLEAN,
  Secretary BOOLEAN,
  Treasurer BOOLEAN,
  Class_President BOOLEAN,
  Class_Senator BOOLEAN
);

CREATE TABLE Constraint_Bounds (
  Position_Filled STRING,
  Student_Position_Limit STRING
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in this optimization problem, mapping them to their business purposes and optimization roles. 

- **Voting_record**: This table stores the number of votes each student received for each position. It plays a crucial role in the optimization process by providing the coefficients for the objective function. Each column represents a different position, with the values indicating the number of votes received by a student.

- **Decision_Variables**: This table contains binary decision variables that indicate whether a student is elected to a specific position. Each column corresponds to a different position, and the values are either true or false, representing the election outcome.

- **Constraint_Bounds**: This table stores the constraints that ensure each position is filled by exactly one student and that each student holds at most one position. The constraints are expressed in a linear form, aligning with the optimization model's requirements.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical voting scenarios in a university setting, ensuring a diverse distribution of votes across different positions to reflect realistic election outcomes.

-- Realistic data for Voting_record
INSERT INTO Voting_record (President_Vote, Vice_President_Vote, Secretary_Vote, Treasurer_Vote, Class_President_Vote, Class_Senator_Vote) VALUES (25, 18, 22, 15, 30, 20);
INSERT INTO Voting_record (President_Vote, Vice_President_Vote, Secretary_Vote, Treasurer_Vote, Class_President_Vote, Class_Senator_Vote) VALUES (30, 25, 20, 18, 28, 22);
INSERT INTO Voting_record (President_Vote, Vice_President_Vote, Secretary_Vote, Treasurer_Vote, Class_President_Vote, Class_Senator_Vote) VALUES (20, 30, 25, 22, 18, 25);

-- Realistic data for Decision_Variables
INSERT INTO Decision_Variables (President, Vice_President, Secretary, Treasurer, Class_President, Class_Senator) VALUES (True, False, False, False, False, False);
INSERT INTO Decision_Variables (President, Vice_President, Secretary, Treasurer, Class_President, Class_Senator) VALUES (False, True, False, False, False, False);
INSERT INTO Decision_Variables (President, Vice_President, Secretary, Treasurer, Class_President, Class_Senator) VALUES (False, False, True, False, False, False);

-- Realistic data for Constraint_Bounds
INSERT INTO Constraint_Bounds (Position_Filled, Student_Position_Limit) VALUES ('sum(x[i] for all i) = 1', 'x[i] + y[i] + z[i] + w[i] + u[i] + v[i] <= 1');
```