# Complete Optimization Problem and Solution: workshop_paper

## 1. Problem Context and Goals

### Context  
The conference organizer is tasked with selecting submissions for various workshops, aiming to maximize the overall quality of accepted submissions. Each submission is evaluated based on a quality score, and the decision to accept a submission is represented by a binary variable indicating acceptance status. The organizer must ensure that each workshop meets a minimum number of accepted submissions while not exceeding the venue's capacity. The operational parameters include the minimum number of submissions required per workshop and the maximum number of submissions that can be accepted in each workshop. These parameters are critical in guiding the decision-making process and ensuring that the optimization problem remains linear. The business configuration includes scalar parameters that define these constraints, ensuring that the optimization aligns with the operational realities of the conference.

### Goals  
The primary goal of the optimization is to maximize the total score of accepted submissions. This involves selecting submissions that contribute the highest quality scores while adhering to the constraints of venue capacity and minimum submission requirements. The success of this optimization is measured by the total score achieved, which is calculated by summing the quality scores of all accepted submissions. The objective is clearly defined in linear terms, focusing on maximizing the sum of scores associated with accepted submissions.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the feasibility of the solution:

- Each workshop has a maximum capacity, which means the total number of accepted submissions for any workshop must not exceed its designated capacity. This constraint ensures that the venue's limitations are respected.
  
- Additionally, each workshop must have a minimum number of accepted submissions to ensure that the workshop is viable and meets the expectations of attendees. This constraint guarantees that workshops are sufficiently populated.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains tractable and aligned with the operational goals of the conference.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for venue capacity and minimum submissions per workshop, modifying existing tables to improve mapping adequacy, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE submission (
  Scores FLOAT
);

CREATE TABLE VenueCapacity (
  workshop_id INTEGER,
  capacity INTEGER
);

CREATE TABLE WorkshopSubmissions (
  workshop_id INTEGER,
  min_submissions INTEGER
);

CREATE TABLE Acceptance (
  Result BOOLEAN,
  workshop_id INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Submission Table**: This table stores information about each submission, specifically the quality score, which is used to calculate the total score of accepted submissions. The scores range from 0.0 to 10.0, reflecting the quality of each submission.

- **VenueCapacity Table**: This table records the maximum capacity for each workshop, linking the capacity to specific workshops. The capacity represents the maximum number of submissions that can be accepted, ensuring that the venue's limitations are respected.

- **WorkshopSubmissions Table**: This table captures the minimum required submissions for each workshop, linking these requirements to specific workshops. The minimum submissions ensure that each workshop is viable and meets the expectations of attendees.

- **Acceptance Table**: This table tracks the acceptance status of submissions, indicating whether a submission is accepted. The acceptance status is a binary decision variable in the optimization process, associating submissions with specific workshops.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical conference workshop sizes and submission quality scores, ensuring a balance between capacity and minimum submission requirements.

-- Realistic data for submission
INSERT INTO submission (Scores) VALUES (8.5);
INSERT INTO submission (Scores) VALUES (6.0);
INSERT INTO submission (Scores) VALUES (9.2);
INSERT INTO submission (Scores) VALUES (7.3);
INSERT INTO submission (Scores) VALUES (5.5);

-- Realistic data for VenueCapacity
INSERT INTO VenueCapacity (workshop_id, capacity) VALUES (1, 50);
INSERT INTO VenueCapacity (workshop_id, capacity) VALUES (2, 100);
INSERT INTO VenueCapacity (workshop_id, capacity) VALUES (3, 150);

-- Realistic data for WorkshopSubmissions
INSERT INTO WorkshopSubmissions (workshop_id, min_submissions) VALUES (1, 3);
INSERT INTO WorkshopSubmissions (workshop_id, min_submissions) VALUES (2, 5);
INSERT INTO WorkshopSubmissions (workshop_id, min_submissions) VALUES (3, 7);

-- Realistic data for Acceptance
INSERT INTO Acceptance (Result, workshop_id) VALUES (True, 1);
INSERT INTO Acceptance (Result, workshop_id) VALUES (False, 1);
INSERT INTO Acceptance (Result, workshop_id) VALUES (True, 2);
INSERT INTO Acceptance (Result, workshop_id) VALUES (True, 3);
INSERT INTO Acceptance (Result, workshop_id) VALUES (False, 3);
```