# Dolphin

We provide the code for the paper "DOLPHIN: A PROGRAMMABLE FRAMEWORK FOR SCALABLE NEUROSYMBOLIC LEARNING" in this folder.
We also provide the appendix for our paper here.

## Appendix

The appendix is in the file `appendix.pdf`.

## Code
The code for our neurosymbolic framework is in `./dolphin/symbolic`.
We provide the Dolphin programs for the experiments in the paper in `./dolphin/experiments`:
- The code for MNIST-SumN is in `./experiments/mnist/sum_n.py`
- The code for HWF is in `./experiments/hwf/hwf_dolphin.py`
- The code for PathFinder is in `./experiments/pathfinder/run_*_dolphin.py`
- The code for CLUTRR is in `./experiments/clutrr/run_dolphin.py`
- The code for Mugen is in `./experiments/mugen/run_dolphin.py`

## Installation
In order to install Dolphin, run
```bash
pip install -e .
```
Dolphin needs Python 3.10 to run.

## Running MNIST-SumN

The code for MNIST-SumN will download all the necessary data.
To run MNIST-SumN, run
```bash
python ./experiments/mnist/sum_n.py --sum-n=$N --device=cuda --provenance=damp
```
where `$N` is the number of digits to sum.

For example:
```bash
python ./experiments/mnist/sum_n.py --sum-n=5 --device=cuda --provenance=damp
```