# Heterogeneous-Modal Unsupervised Domain Adaptation via Latent Space Bridging
Official code for the paper "Heterogeneous-Modal Unsupervised Domain Adaptation via Latent Space Bridging".

## Preparation 
### Prerequisites
* PyTorch 1.13.1
* CUDA 11.7
* Python 3.10
* [SparseConvNet](https://github.com/facebookresearch/SparseConvNet)
* [nuscenes-devkit](https://github.com/nutonomy/nuscenes-devkit)
You can follow the next steps to install the requairmented environment. This code is mainly modified from [xMUDA](https://github.com/valeoai/xmuda_journal), you can also refer to its README if the installation isn't going well.
### Installation
#### Install SparseConvNet
Download the [SparseConveNet](https://github.com/facebookresearch/SparseConvNet) to your computer, decompress, enter and develop it:
```
cd SparseConvNet/
bash develop.sh
```
#### Install nuscenes-devkit
Download the [devkit](https://github.com/nutonomy/nuscenes-devkit) to your computer, decompress and enter it.

Add the `python-sdk` directory to your `PYTHONPATH` environmental variable, by adding the following to your `~/.bashrc`:
```
export PYTHONPATH="${PYTHONPATH}:$HOME/nuscenes-devkit/python-sdk"
```
Using cmd (make sure the environment "nuscenes" is activated) to install the base environment:
```
pip install -r setup/requirements.txt
```
Setup environment variable:
```
export NUSCENES="/data/sets/nuscenes"
```
Using the cmd to finally install it:
```
pip install nuscenes-devkit
```
After the above steps, the devikit is installed, for any question you can refer to [devikit_installation_help](https://github.com/nutonomy/nuscenes-devkit/blob/master/docs/installation.md)
### Datasets
#### nuScenes-Lidarseg
Download Nuscenes from [NuScenes website](https://www.nuscenes.org/nuscenes#download) and extract it.

Before training, please edit the script `LSB/data/nuscenes_lidarseg/preprocess.py` as follows and then run it.
* `root_dir` should point to the root directory of the NuScenes dataset
* `out_dir` should point to the desired output directory to store the pickle files

#### A2D2
Download the Semantic Segmentation dataset and Sensor Configuration from the [Audi website](https://www.a2d2.audi/a2d2/en/download.html)

Similar to NuScenes preprocessing, please edit the script `LSB/data/a2d2/preprocess.py` as follows and then run it.
* `root_dir` should point to the root directory of the A2D2 dataset
* `out_dir` should point to the desired output directory to store the pickle files

### SemanticKITTI
Download the files from the [SemanticKITTI website](http://semantic-kitti.org/dataset.html) and additionally the [color data](http://www.cvlibs.net/download.php?file=data_odometry_color.zip) from the [Kitti Odometry website](http://www.cvlibs.net/datasets/kitti/eval_odometry.php). Extract everything into the same folder.

Please edit the script `LSB/data/semantic_kitti/preprocess.py` as follows and then run it.
* `root_dir` should point to the root directory of the SemanticKITTI dataset
* `out_dir` should point to the desired output directory to store the pickle files

### VirtualKITTI
Clone the following repo:
```
$ git clone https://github.com/VisualComputingInstitute/vkitti3D-dataset.git
```
Download raw data and extract with following script:
```
$ cd vkitti3D-dataset/tools
$ mkdir path/to/virtual_kitti
$ bash download_raw_vkitti.sh path/to/virtual_kitti
```
Generate point clouds (npy files):
```
$ cd vkitti3D-dataset/tools
$ for i in 0001 0002 0006 0018 0020; do python create_npy.py --root_path path/to/virtual_kitti --out_path path/to/virtual_kitti/vkitti_npy --sequence $i; done
```

Similar to NuScenes preprocessing, we save all points and segmentation labels to a pickle file.

Please edit the script `LSB/data/virtual_kitti/preprocess.py` as follows and then run it.
* `root_dir` should point to the root directory of the VirtualKITTI dataset
* `out_dir` should point to the desired output directory to store the pickle files

## Usage
### LSB
You can train the LSB with:
```
sh train_LSB.sh
```

### Baseline
You can train the baselines (only on source) with:
```
sh train_source_only.sh
```