import os
import json
import numpy as np

def main():
    folder_path = "../results/ctrlg/times/"

    for file_name in os.listdir(folder_path):
        if file_name.endswith(".json"):
            file_path = os.path.join(folder_path, file_name)
            with open(file_path, "r") as f:
                data = json.load(f)
            
            generation_times = [entry["generation_time"] for entry in data.get("sample_times", [])]
            
            if generation_times:
                avg_time = np.mean(generation_times)
                std_error = np.std(generation_times, ddof=1) / np.sqrt(len(generation_times))
                print(f"CTRL-G {file_name}: avg_time = {avg_time:.4f}, std_error = {std_error:.4f}")
            else:
                print(f"CTRL-G {file_name}: No generation_time.")


    folder_path = "../results/gpt2_supervised_commongen/times/"

    for file_name in os.listdir(folder_path):
        if file_name.endswith(".json"):
            file_path = os.path.join(folder_path, file_name)
            with open(file_path, "r") as f:
                data = json.load(f)
            
            times = [entry["time"] for entry in data if "time" in entry]
            
            if times:
                avg_time = np.mean(times)
                std_error = np.std(times, ddof=1) / np.sqrt(len(times))
                print(f"TRIDENT {file_name}: avg_time = {avg_time:.4f}, std_error = {std_error:.4f}")
            else:
                print(f"TRIDENT {file_name}: No time.")

if __name__ == "__main__":
    main()