import spacy
import inflect
import pyinflect

p = inflect.engine()
nlp = spacy.load("en_core_web_md")

def add_inflect_extension(nlp):
    if not spacy.tokens.Token.has_extension("inflect"):
        spacy.tokens.Token.set_extension("inflect", getter=lambda token: pyinflect.getInflection(token.text))

add_inflect_extension(nlp)

def is_verb(word):
    doc = nlp(word)
    return any(token.pos_ == "VERB" for token in doc)

def get_verb_forms(word):
    token = nlp(word)[0]
    base = token.lemma_

    if not base:
        return []

    verb_forms = set([
        base,
        token._.inflect("VBZ"),
        token._.inflect("VBG"),
        token._.inflect("VBD"),
        token._.inflect("VBN")
    ])

    return list(filter(lambda x: x is not None, verb_forms))

def generate_variants_commongen(word):
    words = [word]

    if is_verb(word):
        words.extend(get_verb_forms(word))
    else:
        words.append(p.plural(word))

    variants = set()
    for w in words:
        variants.add(w)
        #variants.add(w.capitalize())

    return list(filter(lambda x: x is not None, variants))

def generate_variants_commongen_ctrlg(token_lists):

    new_token_lists = []
 
    for t in token_lists:
        new_token_lists.append(generate_variants_commongen(t))
 
    return new_token_lists