library(latex2exp)
library(cowplot)
library(gridGraphics)
library(ggplot2)

######## ######## ######## 
######## linear regression 
pflug_lm_large_far = as.numeric(read.csv("epochs_lin_lr_large_theta0_far.csv", header=TRUE, sep = ",", 
                              stringsAsFactors = FALSE)[1,])
pflug_lm_large_close = as.numeric(read.csv("epochs_lin_lr_large_theta0_close.csv", header=TRUE, sep = ",", 
                                stringsAsFactors = FALSE)[1,])
pflug_lm_small_far = as.numeric(read.csv("epochs_lin_lr_small_theta0_far.csv", header=TRUE, sep = ",", 
                              stringsAsFactors = FALSE)[1,])
pflug_lm_small_close = as.numeric(read.csv("epochs_lin_lr_small_theta0_close.csv", header=TRUE, sep = ",", 
                                stringsAsFactors = FALSE)[1,])

split_lm_large_far = as.numeric(read.csv("epochs_lin_lr_large_theta0_far.csv", header=TRUE, sep = ",", 
                              stringsAsFactors = FALSE)[2,])
split_lm_large_close = as.numeric(read.csv("epochs_lin_lr_large_theta0_close.csv", header=TRUE, sep = ",", 
                                stringsAsFactors = FALSE)[2,])
split_lm_small_far = as.numeric(read.csv("epochs_lin_lr_small_theta0_far.csv", header=TRUE, sep = ",", 
                              stringsAsFactors = FALSE)[2,])
split_lm_small_close = as.numeric(read.csv("epochs_lin_lr_small_theta0_close.csv", header=TRUE, sep = ",", 
                                stringsAsFactors = FALSE)[2,])
# (obtained with the 'eyeballing' code)
up_large_far_lm = 10
up_large_close_lm = 5
up_small_far_lm = 100     
up_small_close_lm = 60
low_large_far_lm = 1
low_large_close_lm = 1
low_small_far_lm = 40  
low_small_close_lm = 20

df_large_far = data.frame(epochs = c(pflug_lm_large_far, split_lm_large_far), 
                 lab = as.factor(c(rep(0,100), rep(1,100))))
ggplot(df_large_far) +
        geom_boxplot(aes(x = lab, y = epochs)) +
        geom_hline(yintercept=seq(low_large_far_lm, up_large_far_lm, length.out = 100), 
                   color = 'red', alpha = 0.03) +
        scale_x_discrete(labels=c("0" = "pflug", "1" = "Split")) +
        labs(title = TeX('Linear Regression, $\\eta = 10^{-3}$')) + 
        theme_bw() +
        theme(axis.title.x = element_blank(), axis.text.x = element_text(size=40),
              axis.text.y = element_text(size=40, angle = 90), 
              axis.title.y = element_blank(),
              plot.title = element_text(hjust = 0.5, size = 50))

#ggsave('split_pflug_boxplot_lm_far_large.jpg', width = 30, height = 30, units = 'cm', dpi = 300)


df_large_close = data.frame(epochs = c(pflug_lm_large_close, split_lm_large_close), 
                           lab = as.factor(c(rep(0,100), rep(1,100))))
ggplot(df_large_close) +
        geom_boxplot(aes(x = lab, y = epochs)) +
        geom_hline(yintercept=seq(low_large_close_lm, up_large_close_lm, length.out = 1000), 
                   color = 'red', alpha = 0.015) +
        scale_x_discrete(labels=c("0" = "pflug", "1" = "Split")) +
        labs(title = TeX('Linear Regression, $\\eta = 10^{-3}$')) + 
        theme_bw() +
        theme(axis.title.x = element_blank(), axis.text.x = element_text(size=40),
              axis.text.y = element_text(size=40, angle = 90), 
              axis.title.y = element_blank(),
              plot.title = element_text(hjust = 0.5, size = 50))

#ggsave('split_pflug_boxplot_lm_close_large.jpg', width = 30, height = 30, units = 'cm', dpi = 300)


df_small_far = data.frame(epochs = c(pflug_lm_small_far, split_lm_small_far), 
                          lab = as.factor(c(rep(0,100), rep(1,100))))
ggplot(df_small_far) +
        geom_boxplot(aes(x = lab, y = epochs)) +
        geom_hline(yintercept=seq(low_small_far_lm, up_small_far_lm, length.out = 1000), 
                   color = 'red', alpha = 0.015) +
        scale_x_discrete(labels=c("0" = "pflug", "1" = "Split")) +
        labs(title = TeX('Linear Regression, $\\eta = 10^{-4}$')) + 
        theme_bw() +
        theme(axis.title.x = element_blank(), axis.text.x = element_text(size=40),
              axis.text.y = element_text(size=40, angle = 90), 
              axis.title.y = element_blank(),
              plot.title = element_text(hjust = 0.5, size = 50))

#ggsave('split_pflug_boxplot_lm_far_small.jpg', width = 30, height = 30, units = 'cm', dpi = 300)

df_small_close = data.frame(epochs = c(pflug_lm_small_close, split_lm_small_close), 
                            lab = as.factor(c(rep(0,100), rep(1,100))))
ggplot(df_small_close) +
        geom_boxplot(aes(x = lab, y = epochs)) +
        geom_hline(yintercept=seq(low_small_close_lm, up_small_close_lm, length.out = 1000), 
                   color = 'red', alpha = 0.05) +
        scale_x_discrete(labels=c("0" = "pflug", "1" = "Split")) +
        labs(title = TeX('Linear Regression, $\\eta = 10^{-4}$')) + 
        theme_bw() +
        theme(axis.title.x = element_blank(), axis.text.x = element_text(size=40),
              axis.text.y = element_text(size=40, angle = 90), 
              axis.title.y = element_blank(),
              plot.title = element_text(hjust = 0.5, size = 50))

#ggsave('split_pflug_boxplot_lm_close_small.jpg', width = 30, height = 30, units = 'cm', dpi = 300)



######## ######## ######## 
######## logistic regression 

pflug_log_large_far = as.numeric(read.csv("epochs_log_lr_large_theta0_far.csv", header=TRUE, sep = ",", 
                                         stringsAsFactors = FALSE)[1,])
pflug_log_large_close = as.numeric(read.csv("epochs_log_lr_large_theta0_close.csv", header=TRUE, sep = ",", 
                                           stringsAsFactors = FALSE)[1,])
pflug_log_small_far = as.numeric(read.csv("epochs_log_lr_small_theta0_far.csv", header=TRUE, sep = ",", 
                                         stringsAsFactors = FALSE)[1,])
pflug_log_small_close = as.numeric(read.csv("epochs_log_lr_small_theta0_close.csv", header=TRUE, sep = ",", 
                                           stringsAsFactors = FALSE)[1,])

split_log_large_far = as.numeric(read.csv("epochs_log_lr_large_theta0_far.csv", header=TRUE, sep = ",", 
                                         stringsAsFactors = FALSE)[2,])
split_log_large_close = as.numeric(read.csv("epochs_log_lr_large_theta0_close.csv", header=TRUE, sep = ",", 
                                           stringsAsFactors = FALSE)[2,])
split_log_small_far = as.numeric(read.csv("epochs_log_lr_small_theta0_far.csv", header=TRUE, sep = ",", 
                                         stringsAsFactors = FALSE)[2,])
split_log_small_close = as.numeric(read.csv("epochs_log_lr_small_theta0_close.csv", header=TRUE, sep = ",", 
                                           stringsAsFactors = FALSE)[2,])
# (obtained with the 'eyeballing' code)
up_large_far_log = 20
up_large_close_log = 5
up_small_far_log = 250     
up_small_close_log = 100
low_large_far_log = 5
low_large_close_log = 1
low_small_far_log = 30  
low_small_close_log = 20

df_large_far = data.frame(epochs = c(pflug_log_large_far, split_log_large_far), 
                          lab = as.factor(c(rep(0,100), rep(1,100))))
ggplot(df_large_far) +
        geom_boxplot(aes(x = lab, y = epochs)) +
        geom_hline(yintercept=seq(low_large_far_log, up_large_far_log, length.out = 100), 
                   color = 'red', alpha = 0.12) +
        scale_x_discrete(labels=c("0" = "pflug", "1" = "Split")) +
        labs(title = TeX('Logistic Regression, $\\eta = 10^{-2}$')) + 
        theme_bw() +
        theme(axis.title.x = element_blank(), axis.text.x = element_text(size=40),
              axis.text.y = element_text(size=40, angle = 90), 
              axis.title.y = element_blank(),
              plot.title = element_text(hjust = 0.5, size = 50))

#ggsave('split_pflug_boxplot_log_far_large.jpg', width = 30, height = 30, units = 'cm', dpi = 300)


df_large_close = data.frame(epochs = c(pflug_log_large_close, split_log_large_close), 
                          lab = as.factor(c(rep(0,100), rep(1,100))))
ggplot(df_large_close) +
        geom_boxplot(aes(x = lab, y = epochs)) +
        geom_hline(yintercept=seq(low_large_close_log, up_large_close_log, length.out = 100), 
                   color = 'red', alpha = 0.15) +
        scale_x_discrete(labels=c("0" = "pflug", "1" = "Split")) +
        labs(title = TeX('Logistic Regression, $\\eta = 10^{-2}$')) + 
        theme_bw() +
        theme(axis.title.x = element_blank(), axis.text.x = element_text(size=40),
              axis.text.y = element_text(size=40, angle = 90), 
              axis.title.y = element_blank(),
              plot.title = element_text(hjust = 0.5, size = 50))

#ggsave('split_pflug_boxplot_log_close_large.jpg', width = 30, height = 30, units = 'cm', dpi = 300)

df_small_far = data.frame(epochs = c(pflug_log_small_far, split_log_small_far), 
                          lab = as.factor(c(rep(0,100), rep(1,100))))
ggplot(df_small_far) +
        geom_boxplot(aes(x = lab, y = epochs)) +
        geom_hline(yintercept=seq(low_small_far_log, up_small_far_log, length.out = 200), 
                   color = 'red', alpha = 0.25) +
        scale_x_discrete(labels=c("0" = "pflug", "1" = "Split")) +
        labs(title = TeX('Logistic Regression, $\\eta = 10^{-3}$')) + 
        theme_bw() +
        theme(axis.title.x = element_blank(), axis.text.x = element_text(size=40),
              axis.text.y = element_text(size=40, angle = 90), 
              axis.title.y = element_blank(),
              plot.title = element_text(hjust = 0.5, size = 50))

#ggsave('split_pflug_boxplot_log_far_small.jpg', width = 30, height = 30, units = 'cm', dpi = 300)

df_small_close = data.frame(epochs = c(pflug_log_small_close, split_log_small_close), 
                          lab = as.factor(c(rep(0,100), rep(1,100))))
ggplot(df_small_close) +
        geom_boxplot(aes(x = lab, y = epochs)) +
        geom_hline(yintercept=seq(low_small_close_log, up_small_close_log, length.out = 1000), 
                   color = 'red', alpha = 0.12) +
        scale_x_discrete(labels=c("0" = "pflug", "1" = "Split")) +
        labs(title = TeX('Logistic Regression, $\\eta = 10^{-3}$')) + 
        theme_bw() +
        theme(axis.title.x = element_blank(), axis.text.x = element_text(size=40),
              axis.text.y = element_text(size=40, angle = 90), 
              axis.title.y = element_blank(),
              plot.title = element_text(hjust = 0.5, size = 50))

#ggsave('split_pflug_boxplot_log_close_small.jpg', width = 30, height = 30, units = 'cm', dpi = 300)




