from collections import defaultdict
from data_builder import load_data

def merge_dicts_of_lists(dataset_list: list[dict]) -> dict:
    merged = defaultdict(list)
    for d in dataset_list:
        for key, value in d.items():
            if isinstance(value, list):
                merged[key].extend(value)
            else:
                merged[key].append(value)
    return dict(merged)

def load_training_data(train_dataset_list):
    dataset_list = []
    for data_name in train_dataset_list:
        dataset = load_data(data_name)
        dataset_list.append(dataset)
    ## combine training data
    train_data = merge_dicts_of_lists(dataset_list)
    return train_data

def separated_string(s: str) -> list[str]:
    return s.split('&')
