# setup the environment
echo `date`, Setup the environment ...
set -e  # exit if error

# prepare folders
exp_path=exp_main
data_path=$exp_path/data
res_path=$exp_path/results
mkdir -p $exp_path $data_path $res_path

datasets="squad writing xsum"
source_models="gpt2-xl opt-2.7b gpt-neo-2.7B gpt-j-6B gpt-neox-20b"

# preparing dataset
for D in $datasets; do
  for M in $source_models; do
    echo `date`, Preparing dataset ${D}_${M} ...
    python scripts/data_builder.py --dataset $D --n_samples 500 --base_model_name $M --output_file $data_path/${D}_${M}
  done
done

# White-box Setting
echo `date`, Evaluate models in the white-box setting:

for D in $datasets; do
  train_parts=()
  for d in $datasets; do
    if [[ ${d} != ${D} ]]; then
      train_parts+=("$d")
    fi
  done
  train_dataset="${train_parts[0]}&${train_parts[1]}"

  for M in $source_models; do
    echo `date`, Evaluating AdaDetectGPT/FastDetectGPT on ${D}_${M} ...

    python scripts/AdaDetectGPT.py --sampling_model_name $M --scoring_model_name $M --dataset $D --train_dataset "$train_dataset" --dataset_file $data_path/${D}_${M} --output_file $res_path/${D}_${M}

  done
done


# # Black-box Setting
scoring_models="gpt-neo-2.7B gpt-j-6B"
blackbox_res_path=$exp_path/blackbox_results
mkdir -p $blackbox_res_path
# evaluate Fast-DetectGPT
for D in $datasets; do
  train_lists=()
  for d in $datasets; do
    if [[ ${d} != ${D} ]]; then
      train_lists+=("$d")
    fi
  done
  for M in $source_models; do

    M1=gpt-j-6B  # sampling model
    for M2 in $scoring_models; do
      train_dataset="${data_path}/${train_lists[0]}_${scoring_models}&${data_path}/${train_lists[1]}_${scoring_models}"
      echo `date`, Evaluating AdaDetectGPT on ${D}_${M}.${M1}_${M2} ...
      python scripts/AdaDetectGPT.py --sampling_model_name $M1 --scoring_model_name $M2 --dataset $D --train_dataset "$train_dataset" --dataset_file $data_path/${D}_${M} --output_file $blackbox_res_path/${D}_${M}.${M1}_${M2} --w_func='bspline'

    done
  done
done

