# Dig a Hole and Fill in Sand: Adversary and Hiding Decoupled Steganography

##  Requirements

* python==3.9.18
* pytorch==2.1.0
* torchvision==0.16.0
* scikit-image==0.22.0
* scikit-learn==1.3.0
* scipy==1.11.3
* tensorboard==2.14.0

## Dataset

- In this paper, we use the commonly used dataset COCO. All images are central cropped into 256 × 256.

- For training or testing on your own dataset, change the code in `config.py`:

    `COVER_PATH1 = ''` : Images for training the INN in AHDeS.

    `COVER_PATH2 = ''` : Images for evuluating the security performance of AHDeS. 

## Get Started

- Run `python train_first_phase.py` for training in the first phase.

- Run `python train_second_phase.py` for training in the second phase.

- Run `python deployment.py` for deployment.

- Set the model path and the image path to your local path, change the code in `config.py`.

    ` MODEL_PATH1 = '' ` : Saved model in the first phase of training stage.
    
    ` MODEL_PATH2 = '' ` : Saved model in the second phase of training stage.

    ` STEGO_PATH2 = '' ` : Stego images generated by AHDeS.
 
## Description of the files in this repository

- `checkpoint`: Save models during the run.

- `image` : Save the cover images for training INN and stego images upon by AHDeS.

- `INN_based_hiding_network` : Architecture of invertible neural network.

- `optimization_based_adversary_module` : Architecture of adversary module.

- `saved_model` :  Here we provide a well-trained [INN_model](saved_model/INN_model.pt) and a CNN-based [steganalyzer](saved_model/steganalyzer.pt).
