#!/bin/sh

SERVER=${2:-local} 

echo "[EPT INFO] Running on Local: You should manually load modules"
conda init zsh
source /opt/anaconda3/etc/profile.d/conda.should

ENVS=$(conda env list | awk '{print $1}' )

if [[ $ENVS = *"$1"* ]]; then
    echo "[EPT INFO] \"$1\" already exists. Pass the installation"
else 
    echo "[EPT INFO] Creating $1..."
    conda create -n $1 python=3.8.5 -y
    conda activate "$1"
    echo "[EPT INFO] Done !"

    echo "[EPT INFO] Installing OpenBLAS and PyTorch..."
    conda install pytorch=1.7.1 torchvision cudatoolkit=11.0 -c pytorch -c conda-forge -y
    conda install openblas-devel -c anaconda -y
    echo "[EPT INFO] Done !"

    echo "[EPT INFO] Installing other dependencies..."
    conda install -c anaconda pandas scipy h5py scikit-learn -y
    conda install -c conda-forge plyfile pytorch-lightning=1.4.0 torchmetrics wandb wrapt -y
    pip3 install lightning-bolts
    echo "[EPT INFO] Done !"

    echo "[EPT INFO] Installing MinkowskiEngine..."
    cd MinkowskiEngine
    python3 setup.py install --blas_include_dirs=${CONDA_PREFIX}/include --blas=openblas --force_cuda
    echo "[EPT INFO] Done !"

    echo "[EPT INFO] Installing cuda_ops..."
    cd ../lib
    python3 setup.py install
    cd ..
    echo "[EPT INFO] Done !"

    pip3 install torch-scatter -f https://data.pyg.org/whl/torch-1.7.1+cu111.html
    pip3 install torch-sparse -f https://data.pyg.org/whl/torch-1.7.1+cu111.html
    pip3 install torch-cluster -f https://data.pyg.org/whl/torch-1.7.1+cu111.html
    pip3 install torchnet
    pip3 install torch-geometric
    pip3 install torch_points_kernels
    pip3 install torch_cluster 
    pip3 install pytorch-metric-learning
    pip3 install gdown

    pip3 install hydra-core==1.0.6 

    conda install -c conda-forge matplotlib -y

    NVCC="$(nvcc --version)"
    TORCH="$(python -c "import torch; print(torch.__version__)")"
    ME="$(python -c "import MinkowskiEngine as ME; print(ME.__version__)")"

    echo "[EPT INFO] Finished the installation!"
    echo "[EPT INFO] ========== Configurations =========="
    echo "$NVCC"
    echo "[EPT INFO] PyTorch version: $TORCH"
    echo "[EPT INFO] MinkowskiEngine version: $ME"
    echo "[EPT INFO] ===================================="

fi;
