function [s,sd,sf,sx1,sx2] = newGP_kernel_signle_layer(x1,x2,param)
[m,T1] = size(x1);
[~,T2] = size(x2);
u = T2 - T1;
sigmaw = param.sigmaw(1);
sigmav = param.sigmav;
sigmaa = param.sigmau(1);
sigmab = param.sigmab(1);
sigmah = param.sigmah;
flag = param.nonlinearity;
s = zeros(T1,1);
sd = zeros(T1,1);
sx1 = zeros(T1,1);
sx2 = zeros(T2,1);
%% calculating sigma^(t,t)(x,x)
sx1(1) = (sigmaa^2/m)*(x1(:,1)'*x1(:,1)) + sigmab^2 + sigmah^2*sigmaw^2;
for t = 2:T1
   [Vphi,~] = act(sx1(t-1),sx1(t-1),sx1(t-1),flag);
   sx1(t) = sigmaw^2*Vphi + (sigmaa^2/m)*(x1(:,t)'*x1(:,t) ) + sigmab^2;
end
%% calculating sigma^(t,t)(xp,xp)
sx2(1) = (sigmaa^2/m)*(x2(:,1)'*x2(:,1)) + sigmab^2 + sigmah^2*sigmaw^2;
for t = 2:T2
   [Vphi,~] = act(sx2(t-1),sx2(t-1),sx2(t-1),flag);
   sx2(t) = sigmaw^2*Vphi + (sigmaa^2/m)*(x2(:,t)'*x2(:,t) ) + sigmab^2;
end
%% calculating sigma^{(t,t+u)}(x,xp) and dot{sigma}^{(t,t+u)}(x,xp)
s(1) = (sigmaa^2/m)*(x1(:,1)'*x2(:,1+u)) + sigmab^2;
[~,sd(1)] = act(s(1),sx1(1),sx2(1+u),flag);
for t = 2:T1
    [Vphi,~] = act(s(t-1),sx1(t-1),sx2(t-1+u),flag);
    s(t) = sigmaw^2*Vphi + (sigmaa^2/m)*(x1(:,t)'*x2(:,(t+u))) + sigmab^2;
    [~,sd(t)] = act(s(t),sx1(t),sx2(t+u),flag);
end
[Vphi,~] = act(s(T1),sx1(T1),sx2(T1+u),flag);
sf = sigmav^2*Vphi; 
end

