
import gym
from gym.envs.mujoco.reacher import ReacherEnv


class InfiniteReacher(ReacherEnv, gym.core.Env):

  def step(self, action):
    obs, reward, done, info = super(InfiniteReacher, self).step(action)
    if hasattr(self, 'np_random') and self.np_random.random_sample() < 0.03:
      obs = self.reset()

    return obs, reward, False, info
