import time


class Timer:
    def __init__(self, name):
        self.name = name

    def __enter__(self):
        print(f"Starting {self.name}")
        self.start = time.time()

    def __exit__(self, *args):
        print(f"{self.name} took {time.time() - self.start:.2f} seconds")
