#!/bin/bash

#!/bin/bash

# export WANDB_MODE=disabled

# Optionally set the cache for transformers
# export TRANSFORMERS_CACHE='YOUR_PATH/huggingface'

export model=$1 # llama2 or vicuna
export setup=$2 # behaviors or strings

# Create results folder if it doesn't exist

python -u ../main.py \
    --config="../configs/individual_${model}.py" \
    --config.attack=gcg \
    --config.train_data="../../data/advbench/harmful_${setup}.csv" \
    --config.result_prefix="/work/<name>/RESULTS_LLM_ATTACKS/individual_${setup}_${model}_gcg_offset${data_offset}" \
    --config.n_train_data=10 \
    --config.data_offset=$3 \
    --config.n_steps=1000 \
    --config.test_steps=20 \
    --config.batch_size=4
