#!/bin/bash

# export WANDB_MODE=disabled

# Optionally set the cache for transformers
# export TRANSFORMERS_CACHE='YOUR_PATH/huggingface'

# export model=llama2 # llama2 or vicuna

echo $model

python -u ../main.py \
    --config="../configs/transfer_${model}.py" \
    --config.attack=gcg \
    --config.train_data="../../data/advbench/harmful_behaviors.csv" \
    --config.result_prefix="/work/<name>/RESULTS_LLM_ATTACKS/transfer_${model}_gcg_${1}_progressive" \
    --config.progressive_goals=False \
    --config.stop_on_success=False \
    --config.num_train_models=1 \
    --config.allow_non_ascii=False \
    --config.n_train_data=25 \
    --config.n_test_data=50 \
    --config.n_steps=10000 \
    --config.test_steps=30 \
    --config.batch_size=512 \
    --config.data_offset=$1
