import json
from pathlib import Path
import numpy as np
import matplotlib.pyplot as plt


INPUT_FOLDER = "/work/<name>/RESULTS_LLM_ATTACKS/"
TEST_SET_JB_CUTOFF = 0.8


def read_json_files(folder):
    """
    Read all JSON files in the specified folder and return a list of dictionaries.
    """
    json_dicts = []
    for file in Path(folder).glob("*.json"):
        with open(file, "r") as f:

            if "transfer" not in file.name:
                continue

            json_dict = json.load(f)
            json_dicts.append(json_dict)
            json_dict["fname"] = file.name

    return json_dicts


def get_controls(folder=None):
    """
    Process JSON files to extract controls, goals, and targets whith more optimisation steps than STEPS_CUTOFF.
    """
    if folder is None:
        folder = INPUT_FOLDER
        
    json_dicts = read_json_files(folder)

    passed_controls = []
    for json_dict in json_dicts:
        controls, tests = json_dict["controls"], json_dict["tests"]
        assert len(controls) == len(tests)

        control = None
        best_jb = -1

        for i, test in enumerate(tests):
            
            jb = test["n_passed"][1]/test["total"][1]

            if jb > TEST_SET_JB_CUTOFF and jb > best_jb:
                control = controls[i]
                best_jb = jb

        if control is not None:
            print(f"control: {control} -- n_targets: {len(json_dict['params']['goals'])}")
            passed_controls.append(control)

    print(f"total: {len(json_dicts)}, passed: {len(passed_controls)}")

    return passed_controls


def main():
    controls = get_controls(INPUT_FOLDER)


if __name__ == "__main__":
    main()


