import multiprocessing

from run_toy import train_all_toy
from run_tabular import train_tabular
from run_supernet import train_supernet
from run_large import train_full_resnet50
from run_sequence import train_seq


def main(pool):
    train_all_toy(pool)
    train_tabular(pool)
    train_seq()
    model_names = [
        'standard',
        'Parallel_v1',
        'Parallel_v2',
    ]
    for model_name in model_names:
        train_supernet(model_name)
    data_names = ['CIFAR100', 'CIFAR10', 'FMNIST', 'MNIST', ]
    results = {}
    for data_name in data_names:
        best_loss, best_accuracy = train_full_resnet50(data_name)
        results[data_name] = (best_loss, best_accuracy)
        print(results)


if __name__ == '__main__':
    with multiprocessing.Pool(10) as pool:
        main(pool)
