❄️ Fast training of accurate physics-informed neural networks without gradient descent
========================================
**This repository contains the official implementation of our paper on Fast training of accurate physics-informed neural networks without gradient descent.**

-   This repository includes the source code for solving time-dependent PDEs using: 
    -   Iso-Geometric Finite Element Method (IGA-FEM),
    -   Classical PINNs and other variants of PINNs,
    -   Frozen-PINNs (our proposed approach).

-   The focus on the paper is on **Frozen-PINNs ❄️** - based on the idea of space-time separation, which overcomes two core challenges limiting the performance of PINNs in terms of accuracy and training time: 
    - Inherent challenges posed by the PINN optimization problem.
    - Treating time as an additional spatial dimension.

-   Frozen-PINNs are robust to different PDE settings (shocks, complicated geometries, high-dimensional PDEs), accurate, fast, easy to implement, and preserve temporal causality. ✅ denotes compatibility, and ❌ denotes incompatibility or a need for substantial modifications. (CoD) = Curse of Dimensionality.  

    | **PDE setting**        | **IGA-FEM/FEM**                 | **PINNs**                                | **Frozen-PINNs ❄️**                 |
    |-------------------------|---------------------------------|------------------------------------------|--------------------------------------|
    | Solutions with shocks   | ✅                              | ✅                                       | ✅ (Frozen-PINN-swim)                |
    | Complex domains         | ❌ Difficult to mesh            | ✅ Easy                                  | ✅ Easy                              |
    | High dimensionality     | ❌ (CoD)                        | ✅                                       | ✅                                   |
    | **Performance/features**|                                 |                                          |                                      |
    | Accuracy/Precision      | ✅ High                         | ❌ Low                                   | ✅ High                              |
    | Speed                   | ✅ Fast                         | ❌ Training (slow)                       | ✅ Fast                              |
    | Temporal causality      | ✅                              | ❌ (only soft constraint)                | ✅️                                   |


## Partial Differential Equation (PDE) benchmarks considered in this work.

The PDEs considered in this work along with the key challenges posed by each, and the ground truth solutions are summarized in the following figure: 


![PDE Benchmarks](pde_summary.svg)


Structure
------------
- **frozen_pinns/** contains experiments with Frozen-PINNs.
- **iga/** contains experiments with IGA-FEM.
- **pinns/** contains experiments with PINNs.
- **plots/** contains plotting scripts.

Installation and execution
------------
Please refer to *README.md* files of the subdirectories for how to install the required packages and reproduce the experiments.
