## Frozen-PINNs: Main Idea
Frozen-PINNs is a framework for solving time-dependent partial differential equations using neural network ansatz. Frozen PINNs leverage the principle of space-time separation. The main idea is illustrated in the following figure:
![Gradient-descent-free training of Frozen-PINNs](frozen_pinn_training.svg)

❄️ Frozen-PINNs replace slow iterative gradient-descent-based training of PINNs with a **very fast training algorithm**. 

❄️ Frozen-PINNs achieve **high-precision** on many time-dependent PDEs.

❄️ Frozen-PINNs **impose temporal causality** by construction. 


## Installation
---
In order to install this package, clone the repository and run 
```bash
pip install .
```
in the root directory. 


## Directory structure
- The directory 'data' contains train and test data points on the boundary and in the interior of the domain. 

- The directory 'examples' contains the examples in the paper.
    - README.md file in individual PDE example contains instructions on reproducing the results from the paper for each PDE.

- The directory 'src' contains all the source files for the code.

## How to run the examples
- Open notebooks in the examples directory and run the cells.  