# Advection Equation Experiments

This directory contains Jupyter notebooks to reproduce the experiments and figures from the Frozen PINNs paper related to the **advection equation**.

## Directory

```
swimpde-paper/frozen_pinns/examples/advection_equation/
```

## Notebooks Overview

### 1. High advection speeds: error vs advection coefficient ($\beta$)

* **`adv_coeff_frozen_pinns.ipynb`**

  * Results for the **Frozen-PINNs** for increasing $\beta$.
* **`adv_coeff_elm_swim.ipynb`**

  * Results with **ELM** and **SWIM** methods for increasing $\beta$.

### 2. Convergence Analysis

* **`convergence.ipynb`**

  * Demonstrates **exponential error decay** with increasing model width for Frozen-PINN-ELM and Frozen-PINN-SWIM.

### 3. Long-Time Simulation

* **`long_time_simulation.ipynb`**

  * Simulates the solution over extended time interval for $T = 1000$ seconds.

### 4. Accuracy vs Speed Tradeoff

* **`frozen_pinn_accurate.ipynb`**

  * Frozen-PINN results in the **high-precision regime**.

* **`frozen_pinn_fast.ipynb`**

  * Frozen-PINN results in the **low-precision regime**.

