# High-dimensional heat equation (up to 10 dimensions) experiments. 

This directory contains Python scripts and Jupyter notebooks to reproduce the experiments and figures from the Frozen PINNs paper related to the **high-dimensional diffusion equation on a unit hyper-cube**.

## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_diffusion/
```

## Notebooks Overview


* **`frozen_pinn_elm.ipynb`**

  * Results for the **Frozen-PINNs** with basis functions sampled with the ELM algorithm. 

* **`frozen_pinn_swim_projection.ipynb`**

  * Results for the **Frozen-PINNs** using swim basis functions oriented in the direction of gradients of the initial solution using the projection trick. The orientation of basis functions does not affect the results much in this case. 


## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_diffusion/ablation_svd/
```

  - Contains supplementary scripts with results of ablation study for the SVD layer of the frozen-pinn architecture.  

## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_diffusion/data/
```

  - Contains train and test data for interior and boundary points.

## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_diffusion/convergence/
```
  - Contains supplementary scripts with results of ablation study for the width of the network.

## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_diffusion/projection/
```
  - Contains supplementary scripts for results with Frozen-PINN-swim when the basis functions are placed using pairs of data points projeted on the gradient of the initial condition.

