# 100-dimensional heat equation experiments (Frozen PINNs paper)

This directory contains Python scripts and Jupyter notebooks to reproduce the experiments and figures from the Frozen PINNs paper related to the **100-dimensional diffusion equation on a unit ball**.

## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_diffusion_2/
```

## Notebooks Overview


* **`frozen_pinn_elm.ipynb`**

  * Results for the **Frozen-PINNs** with basis functions sampled with the ELM algorithm. 


## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_diffusion_2/ablation/
```

  - Contains supplementary scripts for running ablation studies and a hyper-parameter search.  

## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_diffusion_2/extra_experiments/
```

  - Contains additional experiments such as fit with linear regression, frozen-pinn-swim, etc.


