# High-dimensional Reaction Diffusion Equation Experiments 

This directory contains Jupyter notebooks to reproduce the experiments and figures from the Frozen PINNs paper related to the **Reaction-Diffusion equation**.

## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_reaction_diff/
```

## Notebooks Overview

* **`visualize_gradients.ipynb`**
  
  * Illustrates how to orient the basis functions appropriately using basis functions sampled with the SWIM algorithm.  


* **`frozen_pinn_elm_no_projection.ipynb`**

  * Results for the **Frozen-PINNs** using elm basis functions (no projection). 

* **`frozen_pinn_swim_projection.ipynb`**
  
  * Results for the **Frozen-PINNs** using appropriately-oriented swim basis functions using the projection trick. 


## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_reaction_diff/10d_reaction_diffusion/
```

  - Contains supplementary scripts for results with Frozen-PINNs on 10-d reaction diffusion equation.

## Directory

```
swimpde-paper/frozen_pinns/examples/high_dim_reaction_diff/ablation_studies/
```

  - Contains supplementary scripts for running ablation studies and a hyper-parameter search.  
