# Non-linear diffusion equation experiments

This directory contains Jupyter notebooks to reproduce the experiments and figures from the Frozen PINNs paper related to the **Non-linear diffusion equation**.

## Directory

```
swimpde-paper/frozen_pinns/examples/non_linear_diffusion/
```

## Notebooks Overview

* **`frozen_pinn_swim.ipynb`**

  * Results for the **Frozen-PINNs** with with basis functions sampled using the SWIM algorithm.   

* **`frozen_pinn_elm.ipynb`**

  * Results for the **Frozen-PINNs** with basis functions sampled using the ELM algorithm. 


## Directory

```
swimpde-paper/frozen_pinns/examples/non_linear_diffusion/ablation_study_svd_layer/
```

  - Contains supplementary scripts with results of ablation study for the SVD layer of the frozen-pinn architecture.  

## Directory

```
swimpde-paper/frozen_pinns/examples/non_linear_diffusion/hyperparam_search/
```

  - Contains supplementary scripts for hyper-parameter search.

## Directory

```
swimpde-paper/frozen_pinns/examples/non_linear_diffusion/swim_geometry/
```

  - Contains a python notebook for solving the non-linear diffusion equation on SWIM geometry (Not included in the paper).