## Folder Structure

The codes for physics-informed networks are organized into three main folders: `PINN`, `Causal_PINN` and `high-dimensional`. Below is a detailed description of each folder and their contents.

### PINN Folder

The `PINN` folder contains tree subfolders, each dedicated to different experiments involving Physics-Informed Neural Networks (PINNs):

1. **Advection**
2. **Burger**
3. **EB**

#### 1. Advection

The `Advection` folder contains experiments related to the linear advection equation. It has two subfolders:

- **Hyperparameter_opt**
  - Contains hyperparameter optimization experiments to choose the best layer width and number of collocation (interior) points.
  - **Running the experiments:**
    - To run with a specific number of collocation points: `python3 LA_beta10_collocation.py num_colloc`
      - Example: `python3 LA_beta10_collocation.py 2000` (for 2000 interior points)
    - To run with a specific layer width: `python3 LA_beta10_neuron.py num_neurons`
      - Example: `python3 LA_beta10_neuron.py 30` (for 30 neurons)
- **Varying_beta**
  - Contains code for running the advection equation with different beta values.
  - **Running the experiments:**
    - `python3 LA_varying_beta.py beta_value`
      - Example: `python3 LA_varying_beta.py 10` (for beta value 10)

- **Results and Trained Models**
  - Each subfolder within an equation contains:
    - **Results**: Figures, errors, and runtimes in CSV format.
    - **Trained Models**: Saved models after training.

- **PINN.py**
  - Contains the model PINN class.

#### 2. Burger

The `Burger` folder contains PINN experiments for the Burgers' equation.

- **Running the experiments:**
  - `python3 Burgers.py`

#### 3. EB

The `EB` folder contains PINN experiments for the Euler-Bernoulli equation.

- **Running the experiments:**
  - `python3 EB.py`

### Causal_PINN Folder

The `Causal_PINN` folder contains codes to reproduce advection and Burgers' results in the paper using causal PINNs.

### high-dimensional Folder

The `high-dimensional` folder contains two subfolders, each dedicated to different experiments involving Physics-Informed Neural Networks (PINNs) for two PDEs:

1. **5DRD**
2. **Heat**

Results for the 5-D reaction-diffusion equation and the heat equation could be reproduced by running the appropriate Python scripts in the 5DRD and Heat sub-directories, respectively.  

## General Notes

- All codes, when run, will use the trained models to output the reported results.
- To retrain the networks, ensure to store old models elsewhere as the current code replaces the previous trained models, figures, and appends to the error and time CSV files.
- For retraining, uncomment the training part containing the block `"history"` and comment out the load model line.

