import pandas as pd
import numpy as np

# Read CSV file and calculate mean and standard deviation
def process_csv(file_name):
    # Read CSV file
    df = pd.read_csv(file_name)
    
    # Extract entries
    entries = df.iloc[:, 0]  # Assuming single column in CSV
    
    # Calculate mean and standard deviation
    mean = np.mean(entries)
    std_dev = np.std(entries)
    
    # Create a new DataFrame for the new row
    new_row = pd.DataFrame([{'Mean': mean, 'Std Dev': std_dev}])
    
    # Concatenate the new row with the existing DataFrame
    df = pd.concat([df, new_row], ignore_index=True)
    
    return df

# Main script logic
if __name__ == '__main__':
    csv_files = ['Rel_err_results_adam.csv', 'RMSE_results_adam.csv', 'Time_results_adam.csv']
    
    for csv_file in csv_files:
        # Process CSV file
        updated_df = process_csv(csv_file)
        
        # Write updated DataFrame back to CSV
        updated_df.to_csv(csv_file, index=False)

