# Contributing to TIS-DPO

Thank you for your interest in contributing to TIS-DPO! We welcome contributions from the community to help improve this project.

## Code of Conduct

Please be respectful and considerate of others when contributing to this project. We expect all contributors to adhere to professional standards of communication and collaboration.

## How to Contribute

### Reporting Issues

If you find a bug or have a suggestion for improvement:

1. Check if the issue already exists in the [issue tracker](https://github.com/exlaw/TIS-DPO/issues)
2. If not, create a new issue with a clear description:
   - For bugs: Include steps to reproduce, expected behavior, and actual behavior
   - For features: Describe the feature and its benefits

### Contributing Code

1. Fork the repository
2. Create a new branch with a descriptive name: `git checkout -b feature/your-feature-name` or `fix/issue-description`
3. Make your changes
4. Run tests to ensure your changes don't break existing functionality
5. Commit your changes with a clear commit message
6. Push to your fork
7. Submit a pull request

### Pull Request Process

1. Ensure your PR provides a clear description of the changes
2. Link any relevant issues
3. Update documentation if necessary
4. Make sure all tests pass
5. Wait for review and address any feedback

## Development Setup

Follow the installation instructions in the README.md file to set up your development environment.

## Code Style Guidelines

- Follow PEP 8 style guidelines for Python code
- Use descriptive variable and function names
- Add comments for complex code sections
- Write docstrings for functions and classes

## Testing

When adding new features or fixing bugs, please include tests that cover your changes when possible.

## Documentation

Update the documentation when adding new features or making changes that affect usage.

## Questions?

If you have any questions about contributing, feel free to open an issue or contact the maintainers.

Thank you for contributing to TIS-DPO! 