import argparse
from worker import AutoAugmentWorker
from config import CONFIG

parser = argparse.ArgumentParser("call one worker")
parser.add_argument('--id', default="0_0", type=str, help='id.')
parser.add_argument("--sleep_interval", type=float, default=0.5)
parser.add_argument("--device", type=str, help="cuda or cpu", default="cpu")

parser.add_argument('--run_id', type=str, help='A unique run id for this optimization run. An easy option is to use the job id of the clusters scheduler.')
# parser.add_argument('--host', type=str, help='host.')
# parser.add_argument('--ns_host', type=str, help='ns_host.')
# parser.add_argument('--ns_port', type=str, help='ns_port.')


parser.add_argument("--code_dir", default="/home/ma-user/work/pytorch_boss_darts", type=str)
parser.add_argument("--log_dir", default="/cache/exps/pt_boss_darts_cifar10/log", type=str)
parser.add_argument('--shared_dir', default="/cache/exps/pt_boss_darts_cifar10/shared", type=str)  # 最后不能有/
parser.add_argument("--bucket_dir", default="s3://bucket-010/yujun")

parser.add_argument("--alg", default="BOSS")
parser.add_argument("--data_set", default="cifar100")
parser.add_argument("--net_name", default="wideresnet")


args, unparsed = parser.parse_known_args()

CONFIG.code_dir = args.code_dir
CONFIG.log_dir = args.log_dir
CONFIG.shared_dir = args.shared_dir
CONFIG.bucket_dir = args.bucket_dir

CONFIG.alg = args.alg
CONFIG.data_set = args.data_set
CONFIG.net_name = args.net_name


w = AutoAugmentWorker(_id=args.id,
                      sleep_interval=args.sleep_interval,
                      device=args.device,
                      run_id=args.run_id,
                      )
w.run(background=False)
exit(0)
