import logging
import logging.config
import os


class Config:
    def __init__(self):
        self.data_set = "cifar10"
        self.code_dir = "/home/yujun/pytorch-bohb"
        self.bucket_dir = "s3://bucket-010/yujun"
        self.log_dir = "/cache/exps/bohb/log"
        self.shared_dir = "/cache/exps/bohb/shared"

        self.ss_steps = 2
        self.min_budget = 1
        self.max_budget = 3
        self.n_iterations = 2
        self.n_workers = 2
        self.run_id = "bohb"
        # self.nic_name = "ib0"

        self.net_name = "wideresnet"
        self.alg = "BOSS"
        self.work_space = "local"


CONFIG = Config()


def init_logging(exp_dir, config_path='logging_config.yaml'):
    """
    initial logging module with config
    :param config_path:
    :return:
    """
    import yaml
    import sys
    try:
        with open(config_path, 'r') as f:
            config = yaml.safe_load(f.read())
        config["handlers"]["info_file_handler"]["filename"] = os.path.join(exp_dir, "info.log")
        config["handlers"]["time_file_handler"]["filename"] = os.path.join(exp_dir, "time.log")
        config["handlers"]["error_file_handler"]["filename"] = os.path.join(exp_dir, "error.log")

        os.makedirs(exp_dir, exist_ok=True)
        logging.config.dictConfig(config)
    except IOError:
        sys.stderr.write('logging config file "%s" not found' % config_path)
        logging.basicConfig(level=logging.DEBUG)
