import os
import math
import matplotlib.pyplot as plt
import numpy as np

w0 = np.array([0.6,0.6])


lambda1 = 4
lambda2 = 1
H = np.array([lambda1, lambda2])

k1 = 100
k2 = 800

# eta1 = 0.999 * 2 / (lambda1 + lambda2)
eta1 = 1.1 / (lambda1)
eta2 = 0.1/lambda1


gd = []
w = np.copy(w0)

for k in range(k1):
    gd.append(w)
    w  = w * (1- eta1 * H)

for k in range(k2):
    gd.append(w)
    w  = w * (1- eta2 * H)

gd = np.array(gd)


sgd = []
w = np.copy(w0)

for k in range(k1):
    sgd.append(w)
    w  = w * (1- 2 * eta1 * H)

for k in range(k2):
    sgd.append(w)
    w  = w * (1- 2 * eta2 * H)

sgd = np.array(sgd)

print(gd[-1])

print(sgd[-1])



plt.figure(1)
plt.scatter(gd[:,0], gd[:,1], c='b',  s=8.0, label='GD')
plt.scatter(sgd[:,0], sgd[:,1], c='r',  s=8.0, label='SGD')
# plt.scatter(sgd[90:,0], sgd[90:,1], c='r',  s=3.5, label='SGD')

w1 = np.arange(-0.4, 1.0, 0.02)
w2 = np.arange(-0.4, 1.0, 0.02)
W1, W2 = np.meshgrid(w1, w2)
W = np.array([[w1, w2] for w1, w2 in zip(np.ravel(W1), np.ravel(W2))])
s = 0.5 * ( lambda1 * W[:,0]**2 + lambda2 * W[:,1]**2)
S = s.reshape(W1.shape)

values = np.arange(0, 1.5, 0.1)
values = values ** 2

c = plt.contour(W1, W2, S, values)
plt.clabel(c, inline=True, fontsize=10)


plt.xlim(-0.4, 1.0)
plt.ylim(-0.4, 1.0)

plt.legend(loc='upper right', markerscale=2, fontsize=16)
plt.show()
plt.savefig('moderateLR.pdf')
