data {
    int<lower=2> k; # Dimensionality of ordinal observations
    int<lower=1> m; # Number of controls
    int<lower=0> n; # Number of data points
    
    int<lower=1, upper=k> y[n];
    matrix[n, m] u;
    ordered[k-1] beta;
    
    vector[n] intervals;
    real mu0;
    real<lower=0> sigma0;
    
    real mu_log_a;
    real<lower=0> sigma_log_a;
}

parameters {
    real<lower=0> sigma;
    vector[n+1] x;
    vector<lower=0>[m] A;
}

model {
    for (i in 1:n) {
        y[i] ~ ordered_logistic(x[i], beta);
        x[i+1] ~ normal(x[i] - dot_product(A, u[i]), sigma * sqrt(intervals[i]));
    }
    log(A[1]) ~ normal(mu_log_a, sigma_log_a);
    x[1] ~ normal(mu0, sigma0);
}
