% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDrugPK.R
\name{getDrugPK}
\alias{getDrugPK}
\title{Get the pharmacokinetic and pharmacodynamic values for a drug based on
patient covariates}
\usage{
getDrugPK(
  drug = "propofol",
  weight = 70,
  height = 170,
  age = 50,
  sex = "male",
  drugDefaults
)
}
\arguments{
\item{drug}{name of drug (string)}

\item{weight}{weight in kg}

\item{height}{height in cm}

\item{age}{age in years}

\item{sex}{sex as string: "female" or "male"}

\item{drugDefaults}{output from \code{getDrugDefaults(drug)}}
}
\description{
See \code{vignette("stanpumpR-single-PK", package = "stanpumpR")} for an example
}
\examples{
PK <- stanpumpR::getDrugPK(
  drug = "remifentanil",
  weight = 70,
  height = 170,
  age = 50,
  sex = "male",
  stanpumpR::getDrugDefaults('remifentanil')
)

}
